/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.shadew.json.AbstractPrimitiveNode;
import net.shadew.json.IncorrectTypeException;
import net.shadew.json.JsonNode;
import net.shadew.json.JsonType;

final class BooleanNode
extends AbstractPrimitiveNode {
    private final boolean bool;
    private final String string;

    BooleanNode(boolean bool) {
        super(JsonType.BOOLEAN);
        this.bool = bool;
        this.string = bool ? "true" : "false";
    }

    @Override
    public JsonNode ifBoolean(BiConsumer<JsonNode, Boolean> action) {
        action.accept(this, this.bool);
        return this;
    }

    @Override
    public String asExactString() {
        throw new IncorrectTypeException(JsonType.BOOLEAN, JsonType.STRING);
    }

    @Override
    public String asString() {
        return this.string;
    }

    @Override
    public byte asByte() {
        throw new IncorrectTypeException(JsonType.BOOLEAN, JsonType.NUMBER);
    }

    @Override
    public short asShort() {
        throw new IncorrectTypeException(JsonType.BOOLEAN, JsonType.NUMBER);
    }

    @Override
    public int asInt() {
        throw new IncorrectTypeException(JsonType.BOOLEAN, JsonType.NUMBER);
    }

    @Override
    public long asLong() {
        throw new IncorrectTypeException(JsonType.BOOLEAN, JsonType.NUMBER);
    }

    @Override
    public float asFloat() {
        throw new IncorrectTypeException(JsonType.BOOLEAN, JsonType.NUMBER);
    }

    @Override
    public double asDouble() {
        throw new IncorrectTypeException(JsonType.BOOLEAN, JsonType.NUMBER);
    }

    @Override
    public BigInteger asBigInteger() {
        throw new IncorrectTypeException(JsonType.BOOLEAN, JsonType.NUMBER);
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new IncorrectTypeException(JsonType.BOOLEAN, JsonType.NUMBER);
    }

    @Override
    public BigDecimal asNumber() {
        throw new IncorrectTypeException(JsonType.BOOLEAN, JsonType.NUMBER);
    }

    @Override
    public boolean asBoolean() {
        return this.bool;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanNode other = (BooleanNode)o;
        return this.bool == other.bool;
    }

    public int hashCode() {
        return Objects.hash(this.bool);
    }

    public String toString() {
        return this.string;
    }
}

