/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json.codec;

import net.shadew.json.JsonNode;
import net.shadew.json.codec.JsonCodec;
import net.shadew.json.codec.JsonCodecException;

class ComparableInCodec<A extends Comparable<A>>
implements JsonCodec<A> {
    private final JsonCodec<A> codec;
    private final A min;
    private final A max;

    ComparableInCodec(JsonCodec<A> codec, A min, A max) {
        this.codec = codec;
        this.min = min;
        this.max = max;
        if (max.compareTo(min) < 0) {
            throw new IllegalArgumentException("max < min");
        }
    }

    private A check(A a) {
        if (a.compareTo(this.min) < 0 || a.compareTo(this.max) > 0) {
            throw new JsonCodecException("Value " + a + " out of range [" + this.min + ", " + this.max + "]");
        }
        return a;
    }

    @Override
    public JsonNode encode(A obj) {
        return this.codec.encode(this.check(obj));
    }

    @Override
    public A decode(JsonNode json) {
        return (A)this.check((Comparable)this.codec.decode(json));
    }
}

