/*
 * Decompiled with CFR 0.152.
 */
package de.glowman554.config;

import de.glowman554.config.Savable;
import java.io.File;
import java.io.IOException;
import net.shadew.json.Json;
import net.shadew.json.JsonNode;

public class ConfigManager {
    public static File BASE_FOLDER = new File("config");
    private final File FILE;
    private JsonNode rootNode;

    public ConfigManager(String id, boolean failIfNotFound) {
        this.FILE = new File(BASE_FOLDER, id + ".json");
        if (this.FILE.exists()) {
            this.load();
        } else {
            if (failIfNotFound) {
                throw new IllegalArgumentException("No config with id " + id + " found!");
            }
            this.rootNode = JsonNode.object();
        }
        this.save();
    }

    private void load() {
        Json json = Json.json();
        try {
            this.rootNode = json.parse(this.FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void save() {
        Json json = Json.json();
        try {
            json.serialize(this.rootNode, this.FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Savable loadValue(String id, Savable structure) {
        JsonNode node = this.rootNode.get(id);
        if (node == null) {
            throw new IllegalArgumentException("No value with id " + id);
        }
        structure.fromJSON(node);
        return structure;
    }

    public void setValue(String id, Savable structure) {
        this.rootNode.set(id, structure.toJSON());
        this.save();
    }
}

