/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

public enum JsonType {
    STRING(true, false),
    NUMBER(true, false),
    BOOLEAN(true, false),
    NULL(false, false),
    ARRAY(false, true),
    OBJECT(false, true);

    static final JsonType[][] EXCLUDING_ARRAYS;
    static final JsonType[] PRIMITIVES;
    static final JsonType[] CONSTRUCTS;
    static final JsonType[] NOT_PRIMITIVES;
    static final JsonType[] NOT_CONSTRUCTS;
    static final JsonType[] WITH_LENGTH;
    static final JsonType[] VALUES;
    private final boolean primitive;
    private final boolean construct;

    private JsonType(boolean primitive, boolean construct) {
        this.primitive = primitive;
        this.construct = construct;
    }

    public static JsonType[] allExcluding(JsonType type) {
        if (type == null) {
            return JsonType.values();
        }
        return (JsonType[])EXCLUDING_ARRAYS[type.ordinal()].clone();
    }

    public static JsonType[] primitives() {
        return (JsonType[])PRIMITIVES.clone();
    }

    public static JsonType[] constructs() {
        return (JsonType[])CONSTRUCTS.clone();
    }

    public static JsonType[] notPrimitives() {
        return (JsonType[])NOT_PRIMITIVES.clone();
    }

    public static JsonType[] notConstructs() {
        return (JsonType[])NOT_CONSTRUCTS.clone();
    }

    static JsonType[] allExcluding0(JsonType type) {
        if (type == null) {
            return VALUES;
        }
        return (JsonType[])EXCLUDING_ARRAYS[type.ordinal()].clone();
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isConstruct() {
        return this.construct;
    }

    public boolean isNull() {
        return this == NULL;
    }

    static {
        EXCLUDING_ARRAYS = new JsonType[][]{{NUMBER, BOOLEAN, NULL, ARRAY, OBJECT}, {STRING, BOOLEAN, NULL, ARRAY, OBJECT}, {STRING, NUMBER, NULL, ARRAY, OBJECT}, {STRING, NUMBER, BOOLEAN, ARRAY, OBJECT}, {STRING, NUMBER, BOOLEAN, NULL, OBJECT}, {STRING, NUMBER, BOOLEAN, NULL, ARRAY}};
        PRIMITIVES = new JsonType[]{STRING, NUMBER, BOOLEAN};
        CONSTRUCTS = new JsonType[]{ARRAY, OBJECT};
        NOT_PRIMITIVES = new JsonType[]{NULL, ARRAY, OBJECT};
        NOT_CONSTRUCTS = new JsonType[]{STRING, NUMBER, BOOLEAN, NULL};
        WITH_LENGTH = new JsonType[]{STRING, ARRAY, OBJECT};
        VALUES = JsonType.values();
    }
}

