/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json.codec;

import net.shadew.json.JsonNode;
import net.shadew.json.codec.JsonCodec;
import net.shadew.json.codec.JsonCodecException;

class ComparableUnderCodec<A extends Comparable<A>>
implements JsonCodec<A> {
    private final JsonCodec<A> codec;
    private final A max;

    ComparableUnderCodec(JsonCodec<A> codec, A max) {
        this.codec = codec;
        this.max = max;
    }

    private A check(A a) {
        if (a.compareTo(this.max) > 0) {
            throw new JsonCodecException("Value " + a + " above limit " + this.max);
        }
        return a;
    }

    @Override
    public JsonNode encode(A obj) {
        return this.codec.encode(this.check(obj));
    }

    @Override
    public A decode(JsonNode json) {
        return (A)this.check((Comparable)this.codec.decode(json));
    }
}

