/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json.codec;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.shadew.json.JsonException;
import net.shadew.json.JsonNode;
import net.shadew.json.JsonType;
import net.shadew.json.codec.BasicCodec;
import net.shadew.json.codec.CheckCodec;
import net.shadew.json.codec.CombinedCodec;
import net.shadew.json.codec.ComparableAboveCodec;
import net.shadew.json.codec.ComparableInCodec;
import net.shadew.json.codec.ComparableUnderCodec;
import net.shadew.json.codec.EncodableCodec;
import net.shadew.json.codec.EnumCodec;
import net.shadew.json.codec.JsonCodecException;
import net.shadew.json.codec.JsonEncodable;
import net.shadew.json.codec.ListCodec;
import net.shadew.json.codec.MapCodec;
import net.shadew.json.codec.MappedCodec;
import net.shadew.json.codec.SetCodec;

public interface JsonCodec<A> {
    public static final JsonCodec<JsonNode> JSON_NODE = JsonCodec.of(Function.identity(), Function.identity());
    public static final JsonCodec<Byte> BYTE = JsonCodec.of(JsonNode::number, JsonNode::asByte);
    public static final JsonCodec<Short> SHORT = JsonCodec.of(JsonNode::number, JsonNode::asShort);
    public static final JsonCodec<Integer> INT = JsonCodec.of(JsonNode::number, JsonNode::asInt);
    public static final JsonCodec<Long> LONG = JsonCodec.of(JsonNode::number, JsonNode::asLong);
    public static final JsonCodec<Float> FLOAT = JsonCodec.of(JsonNode::number, JsonNode::asFloat);
    public static final JsonCodec<Double> DOUBLE = JsonCodec.of(JsonNode::number, JsonNode::asDouble);
    public static final JsonCodec<BigInteger> BIG_INTEGER = JsonCodec.of(JsonNode::number, JsonNode::asBigInteger);
    public static final JsonCodec<BigDecimal> BIG_DECIMAL = JsonCodec.of(JsonNode::number, JsonNode::asBigDecimal);
    public static final JsonCodec<Boolean> BOOLEAN = JsonCodec.of(JsonNode::bool, JsonNode::asBoolean);
    public static final JsonCodec<String> STRING = JsonCodec.of(JsonNode::string, JsonNode::asString);
    public static final JsonCodec<String> EXACT_STRING = JsonCodec.of(JsonNode::string, JsonNode::asExactString);
    public static final JsonCodec<Character> CHAR = JsonCodec.of(ch -> JsonNode.string(ch.toString()), json -> {
        json.require(JsonType.NUMBER, JsonType.STRING);
        if (json.isString()) {
            String str = json.asExactString();
            if (str.length() != 1) {
                throw new JsonCodecException("Character expected, string length must be 1");
            }
            return Character.valueOf(str.charAt(0));
        }
        int i = json.asInt();
        if (i < 0 || i > 65535) {
            throw new JsonCodecException("Character expected, unicode value must be between 0 and \uffff");
        }
        return Character.valueOf((char)i);
    });
    public static final JsonCodec<Integer> CODE_POINT = JsonCodec.of(ch -> JsonNode.string(new String(new int[]{ch}, 0, 1)), json -> {
        json.require(JsonType.NUMBER, JsonType.STRING);
        if (json.isString()) {
            String str = json.asExactString();
            if (str.codePointCount(0, str.length()) != 1) {
                throw new JsonCodecException("Unicode code point expected, string length must be 1 code point");
            }
            return str.codePointAt(0);
        }
        int i = json.asInt();
        if (i < 0 || i > 0x10FFFF) {
            throw new JsonCodecException("Unicode code point expected, unicode value must be between 0 and 1114111");
        }
        return i;
    });
    public static final JsonCodec<UUID> UUID = JsonCodec.of(uuid -> JsonNode.string(uuid.toString()), JsonCodec.wrapExceptions(json -> java.util.UUID.fromString(json.asString())));

    public static <E extends JsonEncodable> JsonCodec<E> ofEncodable(Function<JsonNode, E> instanceFactory) {
        return new EncodableCodec<E>(instanceFactory);
    }

    public static <E extends JsonEncodable> JsonCodec<E> ofEncodable(Supplier<E> instanceFactory) {
        return new EncodableCodec<JsonEncodable>(json -> (JsonEncodable)instanceFactory.get());
    }

    @SafeVarargs
    public static <A> JsonCodec<A> alternatives(JsonCodec<A> ... options) {
        return new CombinedCodec<A>(List.of(options));
    }

    public static <A, N> JsonCodec<A> map(JsonCodec<N> codec, Function<N, A> map, Function<A, N> unmap) {
        return new MappedCodec<A, N>(codec, map, unmap);
    }

    public static <A> JsonCodec<A> of(Function<A, JsonNode> encode, Function<JsonNode, A> decode) {
        return new BasicCodec<A>(encode, decode);
    }

    public static <A, B> Function<A, B> wrapExceptions(Function<A, B> fn) {
        return a -> {
            try {
                return fn.apply(a);
            }
            catch (JsonException exc) {
                throw exc;
            }
            catch (Throwable thr) {
                throw new JsonCodecException(thr.getMessage(), thr);
            }
        };
    }

    public static <A> JsonCodec<List<A>> listOf(JsonCodec<A> elementCodec) {
        return new ListCodec<A>(elementCodec);
    }

    public static <A> JsonCodec<List<A>> listOf(JsonCodec<A> elementCodec, int maxLen) {
        return new ListCodec<A>(elementCodec, maxLen);
    }

    public static <A> JsonCodec<List<A>> listOf(JsonCodec<A> elementCodec, int minLen, int maxLen) {
        return new ListCodec<A>(elementCodec, minLen, maxLen);
    }

    public static <A> JsonCodec<Set<A>> setOf(JsonCodec<A> elementCodec) {
        return new SetCodec<A>(elementCodec);
    }

    public static <A, K> JsonCodec<Map<K, A>> mapOf(JsonCodec<A> elementCodec, Function<K, String> keyToString, Function<String, K> stringToKey) {
        return new MapCodec<A, K>(elementCodec, JsonCodec.wrapExceptions(keyToString), JsonCodec.wrapExceptions(stringToKey));
    }

    public static <A> JsonCodec<Map<String, A>> mapOf(JsonCodec<A> elementCodec) {
        return new MapCodec(elementCodec, Function.identity(), Function.identity());
    }

    public static JsonCodec<Byte> byteIn(byte min, byte max) {
        return new ComparableInCodec<Byte>(BYTE, min, max);
    }

    public static JsonCodec<Byte> byteUnder(byte max) {
        return new ComparableUnderCodec<Byte>(BYTE, max);
    }

    public static JsonCodec<Byte> byteAbove(byte min) {
        return new ComparableAboveCodec<Byte>(BYTE, min);
    }

    public static JsonCodec<Short> shortIn(short min, short max) {
        return new ComparableInCodec<Short>(SHORT, min, max);
    }

    public static JsonCodec<Short> shortUnder(short max) {
        return new ComparableUnderCodec<Short>(SHORT, max);
    }

    public static JsonCodec<Short> shortAbove(short min) {
        return new ComparableAboveCodec<Short>(SHORT, min);
    }

    public static JsonCodec<Integer> intIn(int min, int max) {
        return new ComparableInCodec<Integer>(INT, min, max);
    }

    public static JsonCodec<Integer> intUnder(int max) {
        return new ComparableUnderCodec<Integer>(INT, max);
    }

    public static JsonCodec<Integer> intAbove(int min) {
        return new ComparableAboveCodec<Integer>(INT, min);
    }

    public static JsonCodec<Long> longIn(long min, long max) {
        return new ComparableInCodec<Long>(LONG, min, max);
    }

    public static JsonCodec<Long> longUnder(long max) {
        return new ComparableUnderCodec<Long>(LONG, max);
    }

    public static JsonCodec<Long> longAbove(long min) {
        return new ComparableAboveCodec<Long>(LONG, min);
    }

    public static JsonCodec<Float> floatIn(float min, float max) {
        return new ComparableInCodec<Float>(FLOAT, Float.valueOf(min), Float.valueOf(max));
    }

    public static JsonCodec<Float> floatUnder(float max) {
        return new ComparableUnderCodec<Float>(FLOAT, Float.valueOf(max));
    }

    public static JsonCodec<Float> floatAbove(float min) {
        return new ComparableAboveCodec<Float>(FLOAT, Float.valueOf(min));
    }

    public static JsonCodec<Double> doubleIn(double min, double max) {
        return new ComparableInCodec<Double>(DOUBLE, min, max);
    }

    public static JsonCodec<Double> doubleUnder(double max) {
        return new ComparableUnderCodec<Double>(DOUBLE, max);
    }

    public static JsonCodec<Double> doubleAbove(double min) {
        return new ComparableAboveCodec<Double>(DOUBLE, min);
    }

    public static JsonCodec<BigInteger> bigIntegerIn(BigInteger min, BigInteger max) {
        return new ComparableInCodec<BigInteger>(BIG_INTEGER, min, max);
    }

    public static JsonCodec<BigInteger> bigIntegerUnder(BigInteger max) {
        return new ComparableUnderCodec<BigInteger>(BIG_INTEGER, max);
    }

    public static JsonCodec<BigInteger> bigIntegerAbove(BigInteger min) {
        return new ComparableAboveCodec<BigInteger>(BIG_INTEGER, min);
    }

    public static JsonCodec<BigDecimal> bigDecimalIn(BigDecimal min, BigDecimal max) {
        return new ComparableInCodec<BigDecimal>(BIG_DECIMAL, min, max);
    }

    public static JsonCodec<BigDecimal> bigDecimalUnder(BigDecimal max) {
        return new ComparableUnderCodec<BigDecimal>(BIG_DECIMAL, max);
    }

    public static JsonCodec<BigDecimal> bigDecimalAbove(BigDecimal min) {
        return new ComparableAboveCodec<BigDecimal>(BIG_DECIMAL, min);
    }

    public static <A extends Comparable<A>> JsonCodec<A> in(JsonCodec<A> codec, A min, A max) {
        return new ComparableInCodec<A>(codec, min, max);
    }

    public static <A extends Comparable<A>> JsonCodec<A> under(JsonCodec<A> codec, A max) {
        return new ComparableUnderCodec<A>(codec, max);
    }

    public static <A extends Comparable<A>> JsonCodec<A> above(JsonCodec<A> codec, A min) {
        return new ComparableAboveCodec<A>(codec, min);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnum(Class<E> type, Function<E, String> namer) {
        return new EnumCodec<Enum>(type, namer, e -> true);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnumIn(Class<E> type, Function<E, String> namer, E from, E to) {
        if (from == null && to == null) {
            return new EnumCodec<Enum>(type, namer, e -> true);
        }
        if (from == null) {
            return new EnumCodec<Enum>(type, namer, e -> e.compareTo(to) <= 0);
        }
        if (to == null) {
            return new EnumCodec<Enum>(type, namer, e -> e.compareTo(from) >= 0);
        }
        return new EnumCodec<Enum>(type, namer, e -> e.compareTo(from) >= 0 && e.compareTo(to) <= 0);
    }

    @SafeVarargs
    public static <E extends Enum<E>> JsonCodec<E> ofEnum(Class<E> type, Function<E, String> namer, E ... options) {
        HashSet<E> set = new HashSet<E>(Arrays.asList(options));
        return new EnumCodec<Enum>(type, namer, set::contains);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnum(Class<E> type, Function<E, String> namer, Collection<? extends E> options) {
        HashSet<? extends E> set = new HashSet<E>(options);
        return new EnumCodec<Enum>(type, namer, set::contains);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnum(Class<E> type, Function<E, String> namer, Predicate<E> check) {
        return new EnumCodec<E>(type, namer, check);
    }

    public static <A> JsonCodec<A> check(JsonCodec<A> codec, Predicate<A> predicate, Function<A, String> error) {
        return new CheckCodec<A>(codec, predicate, error);
    }

    public static <A> JsonCodec<A> check(JsonCodec<A> codec, Predicate<A> predicate, Supplier<String> error) {
        return new CheckCodec<Object>(codec, predicate, a -> (String)error.get());
    }

    public static <A> JsonCodec<A> check(JsonCodec<A> codec, Predicate<A> predicate, String error) {
        return new CheckCodec<Object>(codec, predicate, a -> error);
    }

    public static <A> JsonCodec<A> check(JsonCodec<A> codec, Predicate<A> predicate) {
        return new CheckCodec<Object>(codec, predicate, a -> "Invalid value " + a);
    }

    public static JsonCodec<String> stringMatching(String pattern) {
        return JsonCodec.stringMatching(Pattern.compile(pattern));
    }

    public static JsonCodec<String> stringMatching(Pattern pattern) {
        return new CheckCodec<String>(STRING, str -> pattern.matcher((CharSequence)str).matches(), str -> "'" + str + "' does not match '" + pattern.pattern() + "'");
    }

    public static JsonCodec<String> string(int minLen, int maxLen) {
        return new CheckCodec<String>(STRING, str -> {
            int len = str.length();
            return len >= minLen && len <= maxLen;
        }, str -> "String '" + str + "' length is out of range [" + minLen + "," + maxLen + "]");
    }

    public static JsonCodec<String> string(int maxLen) {
        return new CheckCodec<String>(STRING, str -> {
            int len = str.length();
            return len <= maxLen;
        }, str -> "String '" + str + "' length is above limit " + maxLen);
    }

    public JsonNode encode(A var1);

    public A decode(JsonNode var1);
}

