/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json.codec;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.shadew.json.JsonException;
import net.shadew.json.JsonNode;
import net.shadew.json.codec.JsonCodec;
import net.shadew.json.codec.JsonCodecException;

public class MapCodec<A, K>
implements JsonCodec<Map<K, A>> {
    private final JsonCodec<A> valueCodec;
    private final Function<K, String> keyToString;
    private final Function<String, K> stringToKey;

    public MapCodec(JsonCodec<A> valueCodec, Function<K, String> keyToString, Function<String, K> stringToKey) {
        this.valueCodec = valueCodec;
        this.keyToString = keyToString;
        this.stringToKey = stringToKey;
    }

    @Override
    public JsonNode encode(Map<K, A> obj) {
        JsonNode json = JsonNode.object();
        obj.forEach((k, a) -> {
            String key = this.keyToString.apply(k);
            try {
                json.set(key, this.valueCodec.encode(a));
            }
            catch (JsonException exc) {
                throw new JsonCodecException(key + " > " + exc.getMessage(), exc);
            }
        });
        return json;
    }

    @Override
    public Map<K, A> decode(JsonNode json) {
        HashMap map = new HashMap();
        json.forEachEntry((key, a) -> {
            try {
                map.put(this.stringToKey.apply((String)key), this.valueCodec.decode((JsonNode)a));
            }
            catch (JsonException exc) {
                throw new JsonCodecException(key + " > " + exc.getMessage(), exc);
            }
        });
        return map;
    }
}

