/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.io.IOException;
import java.io.UncheckedIOException;
import net.shadew.json.AbstractLexer;
import net.shadew.json.JsonReader;
import net.shadew.json.JsonSyntaxException;
import net.shadew.json.Token;
import net.shadew.json.TokenType;

class LexerReader
implements JsonReader {
    private final Token nextToken = new Token();
    private final AbstractLexer lexer;
    private boolean hasNext;

    LexerReader(AbstractLexer lexer, boolean skipNonExecute) {
        this.lexer = lexer;
        if (skipNonExecute) {
            try {
                lexer.skipNonExecutePrefixes();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private Token next() throws JsonSyntaxException {
        if (!this.hasNext) {
            try {
                this.lexer.token(this.nextToken);
                this.hasNext = true;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.nextToken;
    }

    private Token next(TokenType expectedType) throws JsonSyntaxException {
        Token next = this.next();
        TokenType nextType = next.getType();
        if (nextType == expectedType) {
            return next;
        }
        throw next.error("Expected " + expectedType.getErrorName());
    }

    @Override
    public boolean readBoolean() throws JsonSyntaxException {
        Token next = this.next(TokenType.BOOLEAN);
        this.hasNext = false;
        return (Boolean)next.getValue();
    }

    @Override
    public String readString() throws JsonSyntaxException {
        Token next = this.next(TokenType.STRING);
        this.hasNext = false;
        return (String)next.getValue();
    }

    @Override
    public String readIdentifier() throws JsonSyntaxException {
        Token next = this.next(TokenType.IDENTIFIER);
        this.hasNext = false;
        return (String)next.getValue();
    }

    @Override
    public String readKey() throws JsonSyntaxException {
        Token next = this.next();
        TokenType nextType = next.getType();
        if (nextType == TokenType.STRING || nextType == TokenType.IDENTIFIER) {
            this.hasNext = false;
            return next.getValue().toString();
        }
        throw next.error("Expected " + TokenType.STRING.getErrorName() + ", " + TokenType.IDENTIFIER.getErrorName());
    }

    @Override
    public Number readNumber() throws JsonSyntaxException {
        Token next = this.next(TokenType.NUMBER);
        this.hasNext = false;
        return (Number)next.getValue();
    }

    @Override
    public void readNull() throws JsonSyntaxException {
        this.next(TokenType.NULL);
        this.hasNext = false;
    }

    @Override
    public void readObjectStart() throws JsonSyntaxException {
        this.next(TokenType.OBJECT_START);
        this.hasNext = false;
    }

    @Override
    public void readObjectEnd() throws JsonSyntaxException {
        this.next(TokenType.OBJECT_END);
        this.hasNext = false;
    }

    @Override
    public void readArrayStart() throws JsonSyntaxException {
        this.next(TokenType.ARRAY_START);
        this.hasNext = false;
    }

    @Override
    public void readArrayEnd() throws JsonSyntaxException {
        this.next(TokenType.ARRAY_END);
        this.hasNext = false;
    }

    @Override
    public void readColon() throws JsonSyntaxException {
        this.next(TokenType.COLON);
        this.hasNext = false;
    }

    @Override
    public void readComma() throws JsonSyntaxException {
        this.next(TokenType.COMMA);
        this.hasNext = false;
    }

    @Override
    public TokenType peekToken() throws JsonSyntaxException {
        return this.next().getType();
    }

    @Override
    public void readToken() throws JsonSyntaxException {
        this.next();
        this.hasNext = false;
    }

    @Override
    public void close() {
        try {
            this.lexer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public JsonSyntaxException error(String message) {
        try {
            return this.next().error(message);
        }
        catch (JsonSyntaxException exc) {
            return exc;
        }
    }
}

