/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json.codec;

import java.util.function.Function;
import net.shadew.json.JsonNode;
import net.shadew.json.codec.JsonCodec;
import net.shadew.json.codec.JsonEncodable;

class EncodableCodec<A extends JsonEncodable>
implements JsonCodec<A> {
    private final Function<JsonNode, A> instanceFactory;

    EncodableCodec(Function<JsonNode, A> instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    @Override
    public JsonNode encode(A obj) {
        return obj.toJson();
    }

    @Override
    public A decode(JsonNode json) {
        JsonEncodable obj = (JsonEncodable)this.instanceFactory.apply(json);
        obj.fromJson(json);
        return (A)obj;
    }
}

