/*
 * Decompiled with CFR 0.152.
 */
package de.glowman554.config.premade;

import de.glowman554.config.Savable;
import de.glowman554.config.auto.AutoSavable;
import de.glowman554.config.auto.JsonProcessor;
import java.util.ArrayList;
import net.shadew.json.JsonNode;

public class ArrayListSavable<T>
extends ArrayList<T>
implements Savable {
    private final JsonProcessor processor;
    private final ConstructorReference<T> constructorReference;

    public ArrayListSavable(JsonProcessor processor, ConstructorReference<T> constructorReference) {
        this.constructorReference = constructorReference;
        if (processor == null) {
            throw new IllegalArgumentException("No valid JsonProcessor!");
        }
        this.processor = processor;
    }

    public ArrayListSavable(Class<T> clazz, ConstructorReference<T> constructorReference) {
        this(AutoSavable.getProcessors().get(clazz), constructorReference);
    }

    @Override
    public void fromJSON(JsonNode node) {
        this.clear();
        for (JsonNode t : node) {
            this.add(this.processor.fromJson(t, this.constructorReference.create(), false));
        }
    }

    @Override
    public JsonNode toJSON() {
        JsonNode array = JsonNode.array();
        for (Object t : this) {
            array.add(this.processor.toJson(t));
        }
        return array;
    }

    public static interface ConstructorReference<T> {
        public T create();
    }
}

