/*
 * Decompiled with CFR 0.152.
 */
package de.glowman554.config.premade;

import de.glowman554.config.Savable;
import de.glowman554.config.auto.AutoSavable;
import de.glowman554.config.auto.JsonProcessor;
import java.util.ArrayList;
import net.shadew.json.JsonNode;

public class ArrayListSavableOOP<T>
extends ArrayList<T>
implements Savable {
    private final JsonProcessor processor;

    public ArrayListSavableOOP(JsonProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("No valid JsonProcessor!");
        }
        this.processor = processor;
    }

    public ArrayListSavableOOP(Class<T> clazz) {
        this(AutoSavable.getProcessors().get(clazz));
    }

    @Override
    public void fromJSON(JsonNode node) {
        this.clear();
        for (JsonNode t : node) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(t.get("className").asString());
                this.add(this.processor.fromJson(t.get("data"), clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), false));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public JsonNode toJSON() {
        JsonNode array = JsonNode.array();
        for (Object t : this) {
            JsonNode node = JsonNode.object();
            node.set("data", this.processor.toJson(t));
            node.set("className", t.getClass().getTypeName());
            array.add(node);
        }
        return array;
    }

    public static interface ConstructorReference<T> {
        public T create();
    }
}

