/*
 * Decompiled with CFR 0.152.
 */
package de.glowman554.config.premade;

import de.glowman554.config.Savable;
import de.glowman554.config.auto.AutoSavable;
import de.glowman554.config.auto.JsonProcessor;
import java.util.HashSet;
import net.shadew.json.JsonNode;

public class HashSetSavable<T>
extends HashSet<T>
implements Savable {
    private final JsonProcessor processor;
    private final ConstructorReference<T> constructorReference;

    public HashSetSavable(JsonProcessor processor, ConstructorReference<T> constructorReference) {
        this.constructorReference = constructorReference;
        if (processor == null) {
            throw new IllegalArgumentException("No valid JsonProcessor!");
        }
        this.processor = processor;
    }

    public HashSetSavable(Class<T> clazz, ConstructorReference<T> constructorReference) {
        this(AutoSavable.getProcessors().get(clazz), constructorReference);
    }

    @Override
    public void fromJSON(JsonNode node) {
        this.clear();
        for (JsonNode object : node) {
            this.add(this.processor.fromJson(object, this.constructorReference.create(), false));
        }
    }

    @Override
    public JsonNode toJSON() {
        JsonNode root = JsonNode.array();
        for (Object object : this) {
            root.add(this.processor.toJson(object));
        }
        return root;
    }

    public static interface ConstructorReference<T> {
        public T create();
    }
}

