/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import net.shadew.json.FormattingConfig;
import net.shadew.json.Json5Lexer;
import net.shadew.json.JsonLexer;
import net.shadew.json.JsonNode;
import net.shadew.json.JsonReader;
import net.shadew.json.JsonSyntaxException;
import net.shadew.json.LexerReader;
import net.shadew.json.Parser;
import net.shadew.json.ParsingConfig;
import net.shadew.json.Serializer;

public class Json {
    private static final FormattingConfig DEFAULT_FORMAT_CONFIG = FormattingConfig.pretty();
    private static final ParsingConfig DEFAULT_PARSE_CONFIG = ParsingConfig.standard();
    private static final FormattingConfig JSON5_FORMAT_CONFIG = FormattingConfig.pretty().json5(true);
    private static final ParsingConfig JSON5_PARSE_CONFIG = ParsingConfig.standard().json5(true);
    private static final Json JSON = new Json(false);
    private static final Json JSON5 = new Json(true);
    private static final Json COMPACT_JSON = Json.jsonBuilder().formatConfig(FormattingConfig.compact()).build();
    private static final Json COMPACT_JSON5 = Json.json5Builder().formatConfig(FormattingConfig.compact()).build();
    private final FormattingConfig formatConfig;
    private final ParsingConfig parseConfig;
    private final ThreadLocal<StringBuilder> toStringBuilder = ThreadLocal.withInitial(StringBuilder::new);

    private Json(Builder builder) {
        this.formatConfig = builder.formatConfig.copy();
        this.parseConfig = builder.parseConfig.copy();
    }

    private Json(boolean j5) {
        this.formatConfig = j5 ? JSON5_FORMAT_CONFIG : DEFAULT_FORMAT_CONFIG;
        this.parseConfig = j5 ? JSON5_PARSE_CONFIG : DEFAULT_PARSE_CONFIG;
    }

    public static Builder jsonBuilder() {
        return new Builder();
    }

    public static Builder json5Builder() {
        return new Builder().formatConfig(JSON5_FORMAT_CONFIG).parseConfig(JSON5_PARSE_CONFIG);
    }

    public static Json json() {
        return JSON;
    }

    public static Json json5() {
        return JSON5;
    }

    public static Json compactJson() {
        return COMPACT_JSON;
    }

    public static Json compactJson5() {
        return COMPACT_JSON5;
    }

    private JsonReader createReader(Reader reader) {
        if (this.parseConfig.json5()) {
            return new LexerReader(new Json5Lexer(reader), this.parseConfig.allowNonExecutePrefix());
        }
        return new LexerReader(new JsonLexer(reader), this.parseConfig.allowNonExecutePrefix());
    }

    public JsonNode parse(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException();
        }
        return Parser.parse(this.createReader(reader), this.parseConfig);
    }

    public JsonNode parse(String string) throws JsonSyntaxException {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            return this.parse(new StringReader(string));
        }
        catch (JsonSyntaxException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AssertionError((Object)"String reader throws IOException?!");
        }
    }

    public JsonNode parse(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        return this.parse(new InputStreamReader(stream));
    }

    public JsonNode parse(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            JsonNode jsonNode = this.parse(reader);
            return jsonNode;
        }
    }

    public void serialize(JsonNode node, Writer writer) throws IOException {
        if (node == null || writer == null) {
            throw new NullPointerException();
        }
        if (!this.formatConfig.anyValue()) {
            node.requireConstruct();
        }
        Serializer.serialize(node, writer, this.formatConfig);
    }

    public void serialize(JsonNode node, OutputStream stream) throws IOException {
        if (node == null || stream == null) {
            throw new NullPointerException();
        }
        this.serialize(node, new OutputStreamWriter(stream));
    }

    public void serialize(JsonNode node, File file) throws IOException {
        if (node == null || file == null) {
            throw new NullPointerException();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            this.serialize(node, writer);
        }
    }

    public void serialize(JsonNode node, StringBuilder builder) {
        if (node == null || builder == null) {
            throw new NullPointerException();
        }
        if (!this.formatConfig.anyValue()) {
            node.requireConstruct();
        }
        try {
            Serializer.serialize(node, builder, this.formatConfig);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"StringBuilder throws IOException?!");
        }
    }

    public String serialize(JsonNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (!this.formatConfig.anyValue()) {
            node.requireConstruct();
        }
        StringBuilder builder = this.toStringBuilder.get();
        builder.setLength(0);
        this.serialize(node, builder);
        return builder.toString();
    }

    public static class Builder {
        private FormattingConfig formatConfig = DEFAULT_FORMAT_CONFIG;
        private ParsingConfig parseConfig = DEFAULT_PARSE_CONFIG;

        private Builder() {
        }

        public Builder formatConfig(FormattingConfig config) {
            if (config == null) {
                throw new NullPointerException();
            }
            this.formatConfig = config;
            return this;
        }

        public Builder parseConfig(ParsingConfig config) {
            if (config == null) {
                throw new NullPointerException();
            }
            this.parseConfig = config;
            return this;
        }

        public Json build() {
            return new Json(this);
        }
    }
}

