/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.shadew.json.CharUtil;

class UnparsedHexNumber
extends Number {
    private final String number;
    private boolean hasIntValue;
    private int intValue;
    private boolean hasLongValue;
    private long longValue;
    private boolean hasFloatValue;
    private float floatValue;
    private boolean hasDoubleValue;
    private double doubleValue;
    private BigInteger bigIntValue;
    private BigDecimal bigDecValue;
    private boolean isZeroDefined;
    private boolean isZero;

    UnparsedHexNumber(String number) {
        this.number = number;
    }

    public boolean isZero() {
        if (!this.isZeroDefined) {
            boolean zero = true;
            String nr = this.number;
            int start = 2;
            if (nr.startsWith("-")) {
                start = 3;
            }
            if (nr.startsWith("+")) {
                start = 3;
            }
            int l = nr.length();
            for (int i = start; i < l; ++i) {
                char c = nr.charAt(i);
                if (c == '0') continue;
                zero = false;
                break;
            }
            this.isZero = zero;
            this.isZeroDefined = true;
        }
        return this.isZero;
    }

    @Override
    public int intValue() {
        if (!this.hasIntValue) {
            int v = 0;
            int sign = 1;
            String nr = this.number;
            int start = 2;
            if (nr.startsWith("-")) {
                sign = -1;
                start = 3;
            }
            if (nr.startsWith("+")) {
                start = 3;
            }
            int l = nr.length();
            for (int i = start; i < l; ++i) {
                char c = nr.charAt(i);
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw new NumberFormatException("For input string: " + this.number);
                }
                v <<= 4;
                v |= hex;
            }
            this.intValue = v * sign;
            this.hasIntValue = true;
        }
        return this.intValue;
    }

    @Override
    public long longValue() {
        if (!this.hasLongValue) {
            long v = 0L;
            long sign = 1L;
            String nr = this.number;
            int start = 2;
            if (nr.startsWith("-")) {
                sign = -1L;
                start = 3;
            }
            if (nr.startsWith("+")) {
                start = 3;
            }
            int l = nr.length();
            for (int i = start; i < l; ++i) {
                char c = nr.charAt(i);
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw new NumberFormatException("For input string: " + this.number);
                }
                v <<= 4;
                v |= (long)hex;
            }
            this.longValue = v * sign;
            this.hasLongValue = true;
        }
        return this.longValue;
    }

    @Override
    public float floatValue() {
        if (!this.hasFloatValue) {
            float v = 0.0f;
            float sign = 1.0f;
            String nr = this.number;
            int start = 2;
            if (nr.startsWith("-")) {
                sign = -1.0f;
                start = 3;
            }
            if (nr.startsWith("+")) {
                start = 3;
            }
            int l = nr.length();
            for (int i = start; i < l; ++i) {
                char c = nr.charAt(i);
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw new NumberFormatException("For input string: " + this.number);
                }
                v *= 16.0f;
                v += (float)hex;
            }
            this.floatValue = v * sign;
            this.hasFloatValue = true;
        }
        return this.floatValue;
    }

    @Override
    public double doubleValue() {
        if (!this.hasDoubleValue) {
            double v = 0.0;
            double sign = 1.0;
            String nr = this.number;
            int start = 2;
            if (nr.startsWith("-")) {
                sign = -1.0;
                start = 3;
            }
            if (nr.startsWith("+")) {
                start = 3;
            }
            int l = nr.length();
            for (int i = start; i < l; ++i) {
                char c = nr.charAt(i);
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw new NumberFormatException("For input string: " + this.number);
                }
                v *= 16.0;
                v += (double)hex;
            }
            this.doubleValue = v * sign;
            this.hasDoubleValue = true;
        }
        return this.doubleValue;
    }

    public BigInteger bigIntegerValue() {
        if (this.bigIntValue == null) {
            boolean sign = true;
            String nr = this.number;
            int start = 2;
            if (nr.startsWith("-")) {
                sign = false;
                start = 3;
            }
            if (nr.startsWith("+")) {
                start = 3;
            }
            String hex = (sign ? "" : "-") + nr.substring(start);
            this.bigIntValue = new BigInteger(hex, 16);
        }
        return this.bigIntValue;
    }

    public BigDecimal bigDecimalValue() {
        if (this.bigDecValue == null) {
            this.bigDecValue = new BigDecimal(this.bigIntegerValue());
        }
        return this.bigDecValue;
    }

    public String toString() {
        return this.number;
    }

    public String toJsonValidString() {
        String sign = this.number.startsWith("-") ? "-" : (this.number.startsWith("+") ? "+" : "");
        BigInteger i = new BigInteger(sign + this.number.substring(sign.length() + 2), 16);
        return i.toString();
    }
}

