/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.graphics.BasicTextImage;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.graphics.ThemeStyle;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.ImageComponent;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.MouseAction;
import java.util.List;

public class SplitPanel
extends Panel {
    private final Component compA;
    private final ImageComponent thumb;
    private final Component compB;
    private boolean isHorizontal;
    private double ratio = 0.5;

    public static SplitPanel ofHorizontal(Component left, Component right) {
        SplitPanel split = new SplitPanel(left, right, true);
        return split;
    }

    public static SplitPanel ofVertical(Component top, Component bottom) {
        SplitPanel split = new SplitPanel(top, bottom, false);
        return split;
    }

    protected SplitPanel(Component a, Component b, boolean isHorizontal) {
        this.compA = a;
        this.compB = b;
        this.isHorizontal = isHorizontal;
        this.thumb = this.makeThumb();
        this.setLayoutManager(new ScrollPanelLayoutManager());
        this.setRatio(10, 10);
        this.addComponent(a);
        this.addComponent(this.thumb);
        this.addComponent(b);
    }

    ImageComponent makeThumb() {
        ImageComponent imageComponent = new ImageComponent(){
            TerminalSize aSize;
            TerminalSize bSize;
            TerminalSize tSize;
            TerminalPosition down = null;
            TerminalPosition drag = null;

            @Override
            public Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
                if (!(keyStroke instanceof MouseAction)) {
                    return Interactable.Result.UNHANDLED;
                }
                MouseAction mouse = (MouseAction)keyStroke;
                if (mouse.isMouseDown()) {
                    this.aSize = SplitPanel.this.compA.getSize();
                    this.bSize = SplitPanel.this.compB.getSize();
                    this.tSize = SplitPanel.this.thumb.getSize();
                    this.down = mouse.getPosition();
                }
                if (mouse.isMouseDrag()) {
                    int delta;
                    this.drag = mouse.getPosition();
                    if (this.down == null) {
                        this.down = this.drag;
                    }
                    int n = delta = SplitPanel.this.isHorizontal ? this.drag.minus(this.down).getColumn() : this.drag.minus(this.down).getRow();
                    if (SplitPanel.this.isHorizontal) {
                        int a = Math.max(1, this.tSize.getColumns() + this.aSize.getColumns() + delta);
                        int b = Math.max(1, this.bSize.getColumns() - delta);
                        SplitPanel.this.setRatio(a, b);
                    } else {
                        int a = Math.max(1, this.tSize.getRows() + this.aSize.getRows() + delta);
                        int b = Math.max(1, this.bSize.getRows() - delta);
                        SplitPanel.this.setRatio(a, b);
                    }
                }
                if (mouse.isMouseUp()) {
                    this.down = null;
                    this.drag = null;
                }
                return Interactable.Result.HANDLED;
            }
        };
        return imageComponent;
    }

    public void setRatio(int left, int right) {
        if (left == 0 || right == 0) {
            this.ratio = 0.5;
        }
        int total = Math.abs(left) + Math.abs(right);
        this.ratio = (double)left / (double)total;
    }

    class ScrollPanelLayoutManager
    implements LayoutManager {
        @Override
        public TerminalSize getPreferredSize(List<Component> components) {
            TerminalSize sizeA = SplitPanel.this.compA.getPreferredSize();
            int aWidth = sizeA.getColumns();
            int aHeight = sizeA.getRows();
            TerminalSize sizeB = SplitPanel.this.compB.getPreferredSize();
            int bWidth = sizeB.getColumns();
            int bHeight = sizeB.getRows();
            int tWidth = SplitPanel.this.thumb.getPreferredSize().getColumns();
            int tHeight = SplitPanel.this.thumb.getPreferredSize().getRows();
            if (SplitPanel.this.isHorizontal) {
                TerminalSize result = new TerminalSize(aWidth + tWidth + bWidth, Math.max(aHeight, Math.max(tHeight, bHeight)));
                return result;
            }
            TerminalSize result = new TerminalSize(Math.max(aWidth, Math.max(tWidth, bWidth)), aHeight + tHeight + bHeight);
            return result;
        }

        @Override
        public void doLayout(TerminalSize area, List<Component> components) {
            TerminalSize size = SplitPanel.this.getSize();
            int length = SplitPanel.this.isHorizontal ? size.getRows() : size.getColumns();
            TerminalSize tsize = new TerminalSize(SplitPanel.this.isHorizontal ? 1 : length, !SplitPanel.this.isHorizontal ? 1 : length);
            BasicTextImage textImage = new BasicTextImage(tsize);
            Theme theme = SplitPanel.this.getTheme();
            ThemeDefinition themeDefinition = theme.getDefaultDefinition();
            ThemeStyle themeStyle = themeDefinition.getNormal();
            textImage.setAll(new TextCharacter(SplitPanel.this.isHorizontal ? (char)'\u2502' : '\u2500', themeStyle.getForeground(), themeStyle.getBackground(), new SGR[0]));
            SplitPanel.this.thumb.setTextImage(textImage);
            int tWidth = SplitPanel.this.thumb.getPreferredSize().getColumns();
            int tHeight = SplitPanel.this.thumb.getPreferredSize().getRows();
            int w = size.getColumns();
            int h = size.getRows();
            if (SplitPanel.this.isHorizontal) {
                w -= tWidth;
            } else {
                h -= tHeight;
            }
            if (SplitPanel.this.isHorizontal) {
                int leftWidth = Math.max(0, (int)((double)w * SplitPanel.this.ratio));
                int leftHeight = Math.max(0, Math.min(SplitPanel.this.compA.getPreferredSize().getRows(), h));
                int rightWidth = Math.max(0, w - leftWidth);
                int rightHeight = Math.max(0, Math.min(SplitPanel.this.compB.getPreferredSize().getRows(), h));
                SplitPanel.this.compA.setSize(new TerminalSize(leftWidth, leftHeight));
                SplitPanel.this.thumb.setSize(SplitPanel.this.thumb.getPreferredSize());
                SplitPanel.this.compB.setSize(new TerminalSize(rightWidth, rightHeight));
                SplitPanel.this.compA.setPosition(new TerminalPosition(0, 0));
                SplitPanel.this.thumb.setPosition(new TerminalPosition(leftWidth, h / 2 - tHeight / 2));
                SplitPanel.this.compB.setPosition(new TerminalPosition(leftWidth + tWidth, 0));
            } else {
                int leftWidth = Math.max(0, Math.min(SplitPanel.this.compA.getPreferredSize().getColumns(), w));
                int leftHeight = Math.max(0, (int)((double)h * SplitPanel.this.ratio));
                int rightWidth = Math.max(0, Math.min(SplitPanel.this.compB.getPreferredSize().getColumns(), w));
                int rightHeight = Math.max(0, h - leftHeight);
                SplitPanel.this.compA.setSize(new TerminalSize(leftWidth, leftHeight));
                SplitPanel.this.thumb.setSize(SplitPanel.this.thumb.getPreferredSize());
                SplitPanel.this.compB.setSize(new TerminalSize(rightWidth, rightHeight));
                SplitPanel.this.compA.setPosition(new TerminalPosition(0, 0));
                SplitPanel.this.thumb.setPosition(new TerminalPosition(w / 2 - tWidth / 2, leftHeight));
                SplitPanel.this.compB.setPosition(new TerminalPosition(0, leftHeight + tHeight));
            }
        }

        @Override
        public boolean hasChanged() {
            return true;
        }
    }
}

