/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.terminal.swing.GraphicalTerminalImplementation;
import com.googlecode.lanterna.terminal.swing.SwingTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorColorConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorDeviceConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalScrollController;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class SwingTerminalImplementation
extends GraphicalTerminalImplementation {
    private final JComponent component;
    private final SwingTerminalFontConfiguration fontConfiguration;

    SwingTerminalImplementation(JComponent component, SwingTerminalFontConfiguration fontConfiguration, TerminalSize initialTerminalSize, TerminalEmulatorDeviceConfiguration deviceConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalScrollController scrollController) {
        super(initialTerminalSize, deviceConfiguration, colorConfiguration, scrollController);
        this.component = component;
        this.fontConfiguration = fontConfiguration;
        component.setMinimumSize(new Dimension(fontConfiguration.getFontWidth(), fontConfiguration.getFontHeight()));
        component.setFocusTraversalKeys(0, Collections.emptySet());
        component.setFocusTraversalKeys(1, Collections.emptySet());
        component.setDoubleBuffered(true);
        component.addKeyListener(new GraphicalTerminalImplementation.TerminalInputListener());
        component.addMouseListener(new GraphicalTerminalImplementation.TerminalMouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SwingTerminalImplementation.this.component.requestFocusInWindow();
            }
        });
        component.addHierarchyListener(e -> {
            if (e.getChangeFlags() == 2L) {
                if (e.getChanged().isDisplayable()) {
                    this.onCreated();
                } else {
                    this.onDestroyed();
                }
            }
        });
    }

    public SwingTerminalFontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    @Override
    protected int getFontHeight() {
        return this.fontConfiguration.getFontHeight();
    }

    @Override
    protected int getFontWidth() {
        return this.fontConfiguration.getFontWidth();
    }

    @Override
    protected int getHeight() {
        return this.component.getHeight();
    }

    @Override
    protected int getWidth() {
        return this.component.getWidth();
    }

    @Override
    protected Font getFontForCharacter(TextCharacter character) {
        return this.fontConfiguration.getFontForCharacter(character);
    }

    @Override
    protected boolean isTextAntiAliased() {
        return this.fontConfiguration.isAntiAliased();
    }

    @Override
    protected void repaint() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.component.repaint();
        } else {
            SwingUtilities.invokeLater(this.component::repaint);
        }
    }

    @Override
    public KeyStroke readInput() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new UnsupportedOperationException("Cannot call SwingTerminal.readInput() on the AWT thread");
        }
        return super.readInput();
    }
}

