/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.backup.core;

import de.toxicfox.backup.core.BackupFile;
import de.toxicfox.backup.core.IUserInterface;
import de.toxicfox.backup.core.ThreadPool;
import de.toxicfox.backup.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import net.shadew.json.JsonNode;

public class Session {
    private final HashSet<String> changedFiles = new HashSet();
    private final HashMap<String, BackupFile> files = new HashMap();
    private long timestamp = System.currentTimeMillis();

    public static Session fromJSON(JsonNode node) {
        Session session = new Session();
        for (String path : node.keySet()) {
            session.files.put(path, BackupFile.fromJson(node.get(path)));
        }
        return session;
    }

    public void startNewSession(IUserInterface user, File directory, String[] excludes) {
        this.timestamp = System.currentTimeMillis();
        user.log("Starting new session: " + this.timestamp);
        HashMap<String, BackupFile> newFiles = new HashMap<String, BackupFile>();
        HashSet<String> excludesSet = new HashSet<String>();
        Collections.addAll(excludesSet, excludes);
        this.indexDirectory(user, directory, directory, newFiles, excludesSet);
        this.changedFiles.clear();
        this.diffPreviousSession(user, newFiles);
    }

    private void threadedCopy(IUserInterface user, String[] paths, File base, File target, boolean restore, FileUtil fileUtil) {
        user.setState(IUserInterface.State.COPYING);
        ThreadPool pool = new ThreadPool();
        int progress = -1;
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            int newProgress = (int)((double)(i + 1) / (double)paths.length * 100.0);
            if (newProgress != progress) {
                progress = newProgress;
                user.setProgress(progress);
            }
            BackupFile file = this.files.get(path);
            File sourceFile = new File(base, path);
            File targetFile = new File(new File(target, String.valueOf(file.timestamp())), path);
            pool.submit(() -> {
                if (restore) {
                    sourceFile.getParentFile().mkdirs();
                } else {
                    targetFile.getParentFile().mkdirs();
                }
                try {
                    if (restore) {
                        fileUtil.copyRestore(targetFile, sourceFile);
                    } else {
                        fileUtil.copyBackup(sourceFile, targetFile);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    user.log("Failed to copy file: " + path);
                    this.files.remove(path);
                }
            });
        }
        pool.stop();
    }

    public void copyChanges(IUserInterface user, File base, File target, FileUtil fileUtil) {
        String[] paths = (String[])this.changedFiles.toArray(String[]::new);
        long size = 0L;
        for (String path : paths) {
            size += new File(base, path).length();
        }
        user.log("Size of changed files: " + FileUtil.formatSize(size));
        long free = target.getFreeSpace();
        if (size > free) {
            throw new RuntimeException("Not enough space on target drive");
        }
        this.threadedCopy(user, paths, base, target, false, fileUtil);
    }

    public void restoreTo(IUserInterface user, File base, File target, FileUtil fileUtil) {
        String[] paths = (String[])this.files.keySet().toArray(String[]::new);
        user.log("Restoring " + paths.length + " files");
        this.threadedCopy(user, paths, base, target, true, fileUtil);
    }

    private void indexDirectory(IUserInterface user, File base, File directory, HashMap<String, BackupFile> output, HashSet<String> excludes) {
        user.setState(IUserInterface.State.INDEXING);
        File[] dir = directory.listFiles();
        if (dir == null) {
            user.log("listFiles() returned null: " + directory.getAbsolutePath());
            return;
        }
        for (File file : dir) {
            if (file.isDirectory()) {
                if (excludes.contains(file.getAbsolutePath())) {
                    user.log("Excluding: " + file.getAbsolutePath());
                    continue;
                }
                this.indexDirectory(user, base, file, output, excludes);
                continue;
            }
            long lastModified = file.lastModified();
            String relative = base.toURI().relativize(file.toURI()).getPath();
            output.put(relative, new BackupFile(lastModified, this.timestamp));
        }
    }

    private void diffPreviousSession(IUserInterface user, HashMap<String, BackupFile> newFiles) {
        user.setState(IUserInterface.State.DIFFING);
        int deletions = 0;
        for (String path : (String[])this.files.keySet().toArray(String[]::new)) {
            BackupFile newFile = newFiles.get(path);
            if (newFile != null) continue;
            this.files.remove(path);
            ++deletions;
        }
        for (String path : newFiles.keySet()) {
            BackupFile newFile = newFiles.get(path);
            BackupFile oldFile = this.files.get(path);
            if (oldFile != null && oldFile.lastModified() == newFile.lastModified()) continue;
            this.files.put(path, newFile);
            this.changedFiles.add(path);
        }
        user.log("Changed files: " + this.changedFiles.size());
        user.log("Deleted files: " + deletions);
    }

    public JsonNode toJSON() {
        JsonNode node = JsonNode.object();
        for (String path : this.files.keySet()) {
            BackupFile file = this.files.get(path);
            node.set(path, file.toJson());
        }
        return node;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

