/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.backup.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class FileUtil {
    private final ArrayList<FileModification> modifications = new ArrayList();

    public void copyBackup(File source, File target) throws IOException {
        try (FileInputStream fis = new FileInputStream(source);
             FileOutputStream fos = new FileOutputStream(target);){
            OutputStream modifiedOut = fos;
            for (FileModification mod : this.modifications) {
                modifiedOut = mod.apply(modifiedOut);
            }
            ((InputStream)fis).transferTo(modifiedOut);
            ((OutputStream)modifiedOut).close();
        }
    }

    public void copyRestore(File source, File target) throws IOException {
        try (FileInputStream fis = new FileInputStream(source);
             FileOutputStream fos = new FileOutputStream(target);){
            InputStream modifiedIn = fis;
            for (FileModification mod : this.modifications) {
                modifiedIn = mod.unapply(modifiedIn);
            }
            ((InputStream)modifiedIn).transferTo(fos);
            ((InputStream)modifiedIn).close();
        }
    }

    public void addModification(FileModification modification) {
        this.modifications.add(modification);
    }

    public static String formatSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        if (size < 0x100000L) {
            return size / 1024L + " KB";
        }
        if (size < 0x40000000L) {
            return size / 1024L / 1024L + " MB";
        }
        return size / 1024L / 1024L / 1024L + " GB";
    }

    public static interface FileModification {
        public OutputStream apply(OutputStream var1) throws IOException;

        public InputStream unapply(InputStream var1) throws IOException;
    }
}

