/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.config.premade;

import de.toxicfox.config.Savable;
import de.toxicfox.config.auto.AutoSavable;
import de.toxicfox.config.auto.JsonProcessor;
import java.util.HashMap;
import net.shadew.json.JsonNode;

public class HashMapSavable<T>
extends HashMap<String, T>
implements Savable {
    private final JsonProcessor processor;
    private final ConstructorReference<T> constructorReference;

    public HashMapSavable(JsonProcessor processor, ConstructorReference<T> constructorReference) {
        this.constructorReference = constructorReference;
        if (processor == null) {
            throw new IllegalArgumentException("No valid JsonProcessor!");
        }
        this.processor = processor;
    }

    public HashMapSavable(Class<T> clazz, ConstructorReference<T> constructorReference) {
        this(AutoSavable.getProcessors().get(clazz), constructorReference);
    }

    @Override
    public void fromJSON(JsonNode node) {
        this.clear();
        for (String key : node.keySet()) {
            this.put(key, this.processor.fromJson(node.get(key), this.constructorReference.create(), false));
        }
    }

    @Override
    public JsonNode toJSON() {
        JsonNode root = JsonNode.object();
        for (String key : this.keySet()) {
            root.set(key, this.processor.toJson(this.get(key)));
        }
        return root;
    }

    public static interface ConstructorReference<T> {
        public T create();
    }
}

