/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import net.shadew.json.CharUtil;
import net.shadew.json.JsonNode;

public final class JsonPath {
    public static final JsonPath ROOT = new JsonPath();
    private final Step[] path;
    private String toString;
    private Integer hashCode;
    private JsonPath parent;

    private JsonPath() {
        this.path = new Step[0];
        this.toString = "";
        this.hashCode = 1;
    }

    private JsonPath(Step[] steps) {
        this.path = steps;
    }

    public static JsonPath rootIndex(int index) {
        return new JsonPath(new Step[]{new Index(index)});
    }

    public static JsonPath rootMember(String key) {
        if (key == null) {
            key = "null";
        }
        return new JsonPath(new Step[]{new Key(key)});
    }

    public static JsonPath parse(String path) {
        if (path == null) {
            throw new NullPointerException("Cannot parse null path.");
        }
        String trim = path.trim();
        if (trim.isEmpty()) {
            return ROOT;
        }
        if (CharUtil.isIdentifierValid(trim)) {
            return JsonPath.rootMember(trim);
        }
        Reader reader = new Reader(trim);
        ArrayList<Step> steps = new ArrayList<Step>();
        Step step = JsonPath.readStep(true, reader);
        while (step != null) {
            steps.add(step);
            step = JsonPath.readStep(false, reader);
        }
        if (steps.size() == 0) {
            assert (false) : "parser did not parse";
            return ROOT;
        }
        Step[] compiled = steps.toArray(new Step[0]);
        return new JsonPath(compiled);
    }

    private static int skipWhitespaces(Reader reader) {
        int c = reader.peek();
        while (CharUtil.isWhitespace5(c)) {
            reader.skip();
            c = reader.peek();
        }
        return c;
    }

    private static Step readStep(boolean first, Reader reader) {
        int c = JsonPath.skipWhitespaces(reader);
        if (c == -1) {
            return null;
        }
        if (c == 46 || first && CharUtil.isIdentifierStart(c)) {
            return JsonPath.readId(reader);
        }
        if (c == 91) {
            reader.skip();
            return JsonPath.readIndex(reader);
        }
        if (first) {
            throw reader.positionalError("Expected identifier, '.' or '['");
        }
        throw reader.positionalError("Expected '.' or '['");
    }

    private static Step readId(Reader reader) {
        int c = reader.peek();
        if (c == 46) {
            reader.skip();
        }
        c = JsonPath.skipWhitespaces(reader);
        StringBuilder builder = reader.builder();
        builder.setLength(0);
        if (!CharUtil.isIdentifierStart(c) && c != 92) {
            throw reader.positionalError("Expected identifier");
        }
        reader.skip();
        if (c == 92) {
            builder.append(JsonPath.readUnicodeEscape(reader));
        } else {
            builder.appendCodePoint(c);
        }
        c = reader.peek();
        while (CharUtil.isIdentifier(c) || c == 92) {
            reader.skip();
            if (c == 92) {
                builder.append(JsonPath.readUnicodeEscape(reader));
            } else {
                builder.appendCodePoint(c);
            }
            c = reader.peek();
        }
        return new Key(builder.toString());
    }

    private static Step readIndex(Reader reader) {
        int c = JsonPath.skipWhitespaces(reader);
        if (c == 34 || c == 39) {
            reader.skip();
            String str = JsonPath.readString(reader, (char)c);
            c = JsonPath.skipWhitespaces(reader);
            if (c != 93) {
                throw reader.positionalError("Expected ']'");
            }
            reader.skip();
            return new Key(str);
        }
        if (CharUtil.isDigit(c) || c == 45 || c == 43) {
            boolean neg = false;
            if (c == 45 || c == 43) {
                neg = c == 45;
                reader.skip();
                c = JsonPath.skipWhitespaces(reader);
            }
            int n = c - 48;
            c = reader.skipAndPeek();
            while (CharUtil.isDigit(c)) {
                int v = c - 48;
                if ((n = n * 10 + v) < 0) {
                    throw reader.positionalError("Number too large");
                }
                c = reader.skipAndPeek();
            }
            c = JsonPath.skipWhitespaces(reader);
            if (c != 93) {
                throw reader.positionalError("Expected ']'");
            }
            reader.skip();
            return new Index(neg ? -n : n);
        }
        throw reader.positionalError("Expected string or number");
    }

    private static String readString(Reader reader, char quote) {
        StringBuilder builder = reader.builder();
        builder.setLength(0);
        int c = reader.peek();
        while (c != quote) {
            if (c == -1) {
                throw reader.positionalError("Unclosed string");
            }
            reader.skip();
            if (c == 92) {
                builder.append(JsonPath.readEscapeStr(reader));
            } else {
                builder.appendCodePoint(c);
            }
            c = reader.peek();
        }
        reader.skip();
        return builder.toString();
    }

    private static char readEscapeStr(Reader reader) {
        int c = reader.peek();
        if (c == 117) {
            return JsonPath.readUnicodeEscape(reader);
        }
        if (c != -1) {
            reader.skip();
            return (char)c;
        }
        throw reader.positionalError("Illegal escape");
    }

    private static char readUnicodeEscape(Reader reader) {
        int c = reader.peek();
        if (c != 117) {
            throw reader.positionalError("Illegal escape");
        }
        reader.skip();
        int hc = 0;
        for (int i = 0; i < 4; ++i) {
            c = reader.peek();
            if (!CharUtil.isHexDigit(c)) {
                throw reader.positionalError("Illegal escape");
            }
            int v = CharUtil.getHexDigitValue(c);
            hc = hc << 4 | v;
            reader.skip();
        }
        return (char)hc;
    }

    public JsonPath parent() {
        if (this.path.length == 1) {
            return ROOT;
        }
        if (this.path.length == 0) {
            throw new NoSuchElementException("Path is root");
        }
        if (this.parent != null) {
            return this.parent;
        }
        Step[] newPath = new Step[this.path.length - 1];
        System.arraycopy(this.path, 0, newPath, 0, this.path.length - 1);
        this.parent = new JsonPath(newPath);
        return this.parent;
    }

    public JsonPath index(int index) {
        Step[] newPath = new Step[this.path.length + 1];
        System.arraycopy(this.path, 0, newPath, 0, this.path.length);
        newPath[this.path.length] = new Index(index);
        return new JsonPath(newPath);
    }

    public JsonPath member(String key) {
        if (key == null) {
            key = "null";
        }
        Step[] newPath = new Step[this.path.length + 1];
        System.arraycopy(this.path, 0, newPath, 0, this.path.length);
        newPath[this.path.length] = new Key(key);
        return new JsonPath(newPath);
    }

    public JsonPath resolve(JsonPath p) {
        if (p == null) {
            throw new NullPointerException("Path to resolve must not be null");
        }
        Step[] newPath = new Step[this.path.length + p.path.length];
        System.arraycopy(this.path, 0, newPath, 0, this.path.length);
        System.arraycopy(p.path, 0, newPath, this.path.length, p.path.length);
        return new JsonPath(newPath);
    }

    public JsonPath resolve(String p) {
        if (p == null) {
            throw new NullPointerException("Path to resolve must not be null");
        }
        return this.resolve(JsonPath.parse(p));
    }

    public JsonPath resolveTo(JsonPath p) {
        if (p == null) {
            throw new NullPointerException("Path to resolve must not be null");
        }
        return p.resolve(this);
    }

    public JsonPath resolveTo(String p) {
        if (p == null) {
            throw new NullPointerException("Path to resolve must not be null");
        }
        return this.resolveTo(JsonPath.parse(p));
    }

    public JsonNode query(JsonNode tree) {
        if (tree == null) {
            throw new NullPointerException();
        }
        for (Step step : this.path) {
            tree = step.get(tree);
        }
        return tree;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPath that = (JsonPath)o;
        return Arrays.equals(this.path, that.path);
    }

    public int hashCode() {
        if (this.hashCode != null) {
            return this.hashCode;
        }
        int hc = Arrays.hashCode(this.path);
        this.hashCode = hc;
        return hc;
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Step step : this.path) {
            step.appendString(first, builder);
            first = false;
        }
        this.toString = builder.toString();
        return this.toString;
    }

    boolean test(Object ... p) {
        int len = p.length;
        if (len != this.path.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.path[i].test(p[i])) continue;
            return false;
        }
        return true;
    }

    private static interface Step {
        public JsonNode get(JsonNode var1);

        public void appendString(boolean var1, StringBuilder var2);

        public boolean test(Object var1);
    }

    private static class Index
    implements Step {
        private final int index;

        private Index(int index) {
            this.index = index;
        }

        @Override
        public JsonNode get(JsonNode parent) {
            return parent.get(this.index);
        }

        @Override
        public void appendString(boolean first, StringBuilder builder) {
            builder.append("[").append(this.index).append("]");
        }

        @Override
        public boolean test(Object test) {
            return test instanceof Number && ((Number)test).intValue() == this.index;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Index that = (Index)obj;
            return this.index == that.index;
        }

        public int hashCode() {
            return this.index;
        }
    }

    private static class Key
    implements Step {
        private final String key;

        private Key(String key) {
            this.key = key;
        }

        @Override
        public JsonNode get(JsonNode parent) {
            return parent.get(this.key);
        }

        @Override
        public void appendString(boolean first, StringBuilder builder) {
            if (CharUtil.isIdentifierValid(this.key)) {
                if (!first) {
                    builder.append(".");
                }
                builder.append(this.key);
            } else {
                builder.append("[\"");
                int l = this.key.length();
                for (int i = 0; i < l; ++i) {
                    char c = this.key.charAt(i);
                    if (c == '\"') {
                        builder.append("\\");
                    }
                    builder.append(c);
                }
                builder.append("\"]");
            }
        }

        @Override
        public boolean test(Object test) {
            return test instanceof String && test.equals(this.key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Key that = (Key)obj;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    private static class Reader {
        private final String string;
        private final StringBuilder builder = new StringBuilder();
        private int pos;

        private Reader(String string) {
            this.string = string;
        }

        int peek() {
            if (this.pos >= this.string.length()) {
                return -1;
            }
            return this.string.charAt(this.pos);
        }

        void skip() {
            if (this.pos < this.string.length()) {
                ++this.pos;
            }
        }

        int skipAndPeek() {
            if (this.pos >= this.string.length()) {
                return -1;
            }
            if (this.pos == this.string.length() - 1) {
                ++this.pos;
                return -1;
            }
            return this.string.charAt(++this.pos);
        }

        IllegalArgumentException positionalError(String error) {
            return new IllegalArgumentException(String.format("Invalid pattern: %s (at pos: %d)%n", error, this.pos) + this.string + System.lineSeparator() + " ".repeat(this.pos) + "^");
        }

        StringBuilder builder() {
            return this.builder;
        }
    }
}

