/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shadew.json.AbstractConstructNode;
import net.shadew.json.IncorrectTypeException;
import net.shadew.json.JsonNode;
import net.shadew.json.JsonType;
import net.shadew.json.StringNode;

final class ObjectNode
extends AbstractConstructNode {
    private final Map<String, JsonNode> children = new LinkedHashMap<String, JsonNode>();
    private EntrySet entrySet;

    ObjectNode() {
        super(JsonType.OBJECT);
    }

    ObjectNode(Map<? extends String, ? extends JsonNode> map) {
        this();
        this.children.putAll(map);
    }

    @Override
    public JsonNode ifObject(Consumer<JsonNode> action) {
        action.accept(this);
        return this;
    }

    @Override
    public Map<String, JsonNode> asMap() {
        return new LinkedHashMap<String, JsonNode>(this.children);
    }

    @Override
    public JsonNode get(int index) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode set(int index, JsonNode value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode set(int index, String value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode set(int index, Number value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode set(int index, Boolean value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode add(JsonNode value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode add(String value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode add(Number value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode add(Boolean value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode insert(int index, JsonNode value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode insert(int index, String value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode insert(int index, Number value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode insert(int index, Boolean value) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode remove(int index) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public int length() {
        return this.children.size();
    }

    @Override
    public JsonNode get(String key) {
        if (key == null) {
            key = "null";
        }
        return this.children.get(key);
    }

    @Override
    public JsonNode set(String key, JsonNode value) {
        if (key == null) {
            key = "null";
        }
        this.children.put(key, JsonNode.orNull(value));
        return this;
    }

    @Override
    public JsonNode set(String key, String value) {
        if (key == null) {
            key = "null";
        }
        this.children.put(key, JsonNode.string(value));
        return this;
    }

    @Override
    public JsonNode set(String key, Number value) {
        if (key == null) {
            key = "null";
        }
        this.children.put(key, JsonNode.number(value));
        return this;
    }

    @Override
    public JsonNode set(String key, Boolean value) {
        if (key == null) {
            key = "null";
        }
        this.children.put(key, JsonNode.bool(value));
        return this;
    }

    @Override
    public JsonNode remove(String key) {
        if (key == null) {
            key = "null";
        }
        this.children.remove(key);
        return this;
    }

    @Override
    public boolean has(String key) {
        if (key == null) {
            key = "null";
        }
        return this.children.containsKey(key);
    }

    @Override
    public boolean contains(JsonNode value) {
        return this.children.containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        return this.children.keySet();
    }

    @Override
    public Collection<JsonNode> values() {
        return this.children.values();
    }

    @Override
    public Set<Map.Entry<String, JsonNode>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this.children.entrySet());
            return this.entrySet;
        }
        return this.entrySet;
    }

    @Override
    public Stream<JsonNode> stream() {
        return this.children.values().stream();
    }

    @Override
    public void forEachEntry(BiConsumer<? super String, ? super JsonNode> fn) {
        this.children.forEach(fn);
    }

    @Override
    public JsonNode deepCopy() {
        ObjectNode copy = new ObjectNode();
        for (Map.Entry<String, JsonNode> e : this.children.entrySet()) {
            copy.children.put(e.getKey(), e.getValue().deepCopy());
        }
        return copy;
    }

    @Override
    public JsonNode copy() {
        return new ObjectNode(this.children);
    }

    @Override
    public Iterator<JsonNode> iterator() {
        return this.children.values().iterator();
    }

    @Override
    public JsonNode clear() {
        this.children.clear();
        return this;
    }

    @Override
    public JsonNode append(JsonNode other) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode prepend(JsonNode other) {
        throw new IncorrectTypeException(JsonType.OBJECT, JsonType.ARRAY);
    }

    @Override
    public JsonNode slice(int from, int to) {
        throw new IncorrectTypeException(this.type(), JsonType.ARRAY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectNode other = (ObjectNode)o;
        return this.children.equals(other.children);
    }

    public int hashCode() {
        return Objects.hash(this.children);
    }

    public String toString() {
        return "{" + this.children.entrySet().stream().map(e -> StringNode.quote((String)e.getKey()) + ": " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + "}";
    }

    private static class EntrySet
    implements Set<Map.Entry<String, JsonNode>> {
        private final Set<Map.Entry<String, JsonNode>> set;
        private final WeakHashMap<Map.Entry<String, JsonNode>, EntryWrapper> wrapperCache = new WeakHashMap();

        private EntrySet(Set<Map.Entry<String, JsonNode>> set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public Iterator<Map.Entry<String, JsonNode>> iterator() {
            return new Itr(this.set.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.set.toArray(a);
        }

        @Override
        public boolean add(Map.Entry<String, JsonNode> stringJsonNodeEntry) {
            throw new UnsupportedOperationException("add");
        }

        @Override
        public boolean remove(Object o) {
            return this.set.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.set.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, JsonNode>> c) {
            throw new UnsupportedOperationException("addAll");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.set.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.set.removeAll(c);
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<String, JsonNode>> action) {
            this.set.forEach((? super T e) -> action.accept(this.wrap((Map.Entry<String, JsonNode>)e)));
        }

        private Map.Entry<String, JsonNode> wrap(Map.Entry<String, JsonNode> e) {
            return this.wrapperCache.computeIfAbsent(e, EntryWrapper::new);
        }

        private class Itr
        implements Iterator<Map.Entry<String, JsonNode>> {
            private final Iterator<Map.Entry<String, JsonNode>> itr;

            private Itr(Iterator<Map.Entry<String, JsonNode>> itr) {
                this.itr = itr;
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Map.Entry<String, JsonNode> next() {
                return EntrySet.this.wrap(this.itr.next());
            }

            @Override
            public void remove() {
                this.itr.remove();
            }

            @Override
            public void forEachRemaining(Consumer<? super Map.Entry<String, JsonNode>> action) {
                this.itr.forEachRemaining((? super E e) -> action.accept(EntrySet.this.wrap((Map.Entry<String, JsonNode>)e)));
            }
        }
    }

    private static class EntryWrapper
    implements Map.Entry<String, JsonNode> {
        private final Map.Entry<String, JsonNode> entry;

        private EntryWrapper(Map.Entry<String, JsonNode> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey();
        }

        @Override
        public JsonNode getValue() {
            return this.entry.getValue();
        }

        @Override
        public JsonNode setValue(JsonNode value) {
            return this.entry.setValue(JsonNode.orNull(value));
        }
    }
}

