/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json.codec;

import java.util.ArrayList;
import java.util.List;
import net.shadew.json.JsonException;
import net.shadew.json.JsonNode;
import net.shadew.json.codec.JsonCodec;
import net.shadew.json.codec.JsonCodecException;

class CombinedCodec<A>
implements JsonCodec<A> {
    private final List<JsonCodec<A>> options;

    CombinedCodec(List<JsonCodec<A>> options) {
        this.options = options;
    }

    @Override
    public JsonNode encode(A obj) {
        ArrayList<JsonException> exceptions = null;
        for (JsonCodec<A> codec : this.options) {
            try {
                return codec.encode(obj);
            }
            catch (JsonException exc) {
                if (exceptions == null) {
                    exceptions = new ArrayList<JsonException>();
                }
                exceptions.add(exc);
            }
        }
        if (exceptions == null) {
            throw new JsonCodecException("Could not encode");
        }
        if (exceptions.size() == 1) {
            throw (JsonException)exceptions.get(0);
        }
        JsonCodecException exc = new JsonCodecException("Could not encode");
        exceptions.forEach(exc::addSuppressed);
        throw exc;
    }

    @Override
    public A decode(JsonNode json) {
        ArrayList<JsonException> exceptions = null;
        for (JsonCodec<A> codec : this.options) {
            try {
                return codec.decode(json);
            }
            catch (JsonException exc) {
                if (exceptions == null) {
                    exceptions = new ArrayList<JsonException>();
                }
                exceptions.add(exc);
            }
        }
        if (exceptions == null) {
            throw new JsonCodecException("Could not decode");
        }
        if (exceptions.size() == 1) {
            throw (JsonException)exceptions.get(0);
        }
        JsonCodecException exc = new JsonCodecException("Could not decode");
        exceptions.forEach(exc::addSuppressed);
        throw exc;
    }
}

