/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.StyleSet;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.graphics.TextImage;
import com.googlecode.lanterna.screen.TabBehaviour;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;

class NullTextGraphics
implements TextGraphics {
    private final TerminalSize size;
    private TextColor foregroundColor;
    private TextColor backgroundColor;
    private TabBehaviour tabBehaviour;
    private final EnumSet<SGR> activeModifiers;

    public NullTextGraphics(TerminalSize size) {
        this.size = size;
        this.foregroundColor = TextColor.ANSI.DEFAULT;
        this.backgroundColor = TextColor.ANSI.DEFAULT;
        this.tabBehaviour = TabBehaviour.ALIGN_TO_COLUMN_4;
        this.activeModifiers = EnumSet.noneOf(SGR.class);
    }

    @Override
    public TerminalSize getSize() {
        return this.size;
    }

    @Override
    public TextGraphics newTextGraphics(TerminalPosition topLeftCorner, TerminalSize size) throws IllegalArgumentException {
        return this;
    }

    @Override
    public TextColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public TextGraphics setBackgroundColor(TextColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @Override
    public TextColor getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public TextGraphics setForegroundColor(TextColor foregroundColor) {
        this.foregroundColor = foregroundColor;
        return this;
    }

    @Override
    public TextGraphics enableModifiers(SGR ... modifiers) {
        this.activeModifiers.addAll(Arrays.asList(modifiers));
        return this;
    }

    @Override
    public TextGraphics disableModifiers(SGR ... modifiers) {
        this.activeModifiers.removeAll(Arrays.asList(modifiers));
        return this;
    }

    @Override
    public TextGraphics setModifiers(EnumSet<SGR> modifiers) {
        this.clearModifiers();
        this.activeModifiers.addAll(modifiers);
        return this;
    }

    @Override
    public TextGraphics clearModifiers() {
        this.activeModifiers.clear();
        return this;
    }

    @Override
    public EnumSet<SGR> getActiveModifiers() {
        return EnumSet.copyOf(this.activeModifiers);
    }

    @Override
    public TabBehaviour getTabBehaviour() {
        return this.tabBehaviour;
    }

    @Override
    public TextGraphics setTabBehaviour(TabBehaviour tabBehaviour) {
        this.tabBehaviour = tabBehaviour;
        return this;
    }

    @Override
    public TextGraphics fill(char c) {
        return this;
    }

    @Override
    public TextGraphics setCharacter(int column, int row, char character) {
        return this;
    }

    @Override
    public TextGraphics setCharacter(int column, int row, TextCharacter character) {
        return this;
    }

    @Override
    public TextGraphics setCharacter(TerminalPosition position, char character) {
        return this;
    }

    @Override
    public TextGraphics setCharacter(TerminalPosition position, TextCharacter character) {
        return this;
    }

    @Override
    public TextGraphics drawLine(TerminalPosition fromPoint, TerminalPosition toPoint, char character) {
        return this;
    }

    @Override
    public TextGraphics drawLine(TerminalPosition fromPoint, TerminalPosition toPoint, TextCharacter character) {
        return this;
    }

    @Override
    public TextGraphics drawLine(int fromX, int fromY, int toX, int toY, char character) {
        return this;
    }

    @Override
    public TextGraphics drawLine(int fromX, int fromY, int toX, int toY, TextCharacter character) {
        return this;
    }

    @Override
    public TextGraphics drawTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, char character) {
        return this;
    }

    @Override
    public TextGraphics drawTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, TextCharacter character) {
        return this;
    }

    @Override
    public TextGraphics fillTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, char character) {
        return this;
    }

    @Override
    public TextGraphics fillTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, TextCharacter character) {
        return this;
    }

    @Override
    public TextGraphics drawRectangle(TerminalPosition topLeft, TerminalSize size, char character) {
        return this;
    }

    @Override
    public TextGraphics drawRectangle(TerminalPosition topLeft, TerminalSize size, TextCharacter character) {
        return this;
    }

    @Override
    public TextGraphics fillRectangle(TerminalPosition topLeft, TerminalSize size, char character) {
        return this;
    }

    @Override
    public TextGraphics fillRectangle(TerminalPosition topLeft, TerminalSize size, TextCharacter character) {
        return this;
    }

    @Override
    public TextGraphics drawImage(TerminalPosition topLeft, TextImage image) {
        return this;
    }

    @Override
    public TextGraphics drawImage(TerminalPosition topLeft, TextImage image, TerminalPosition sourceImageTopLeft, TerminalSize sourceImageSize) {
        return this;
    }

    @Override
    public TextGraphics putString(int column, int row, String string) {
        return this;
    }

    @Override
    public TextGraphics putString(TerminalPosition position, String string) {
        return this;
    }

    @Override
    public TextGraphics putString(int column, int row, String string, SGR extraModifier, SGR ... optionalExtraModifiers) {
        return this;
    }

    @Override
    public TextGraphics putString(TerminalPosition position, String string, SGR extraModifier, SGR ... optionalExtraModifiers) {
        return this;
    }

    @Override
    public TextGraphics putString(int column, int row, String string, Collection<SGR> extraModifiers) {
        return this;
    }

    @Override
    public TextGraphics putCSIStyledString(int column, int row, String string) {
        return this;
    }

    @Override
    public TextGraphics putCSIStyledString(TerminalPosition position, String string) {
        return this;
    }

    @Override
    public TextCharacter getCharacter(int column, int row) {
        return null;
    }

    @Override
    public TextCharacter getCharacter(TerminalPosition position) {
        return null;
    }

    @Override
    public TextGraphics setStyleFrom(StyleSet<?> source) {
        this.setBackgroundColor(source.getBackgroundColor());
        this.setForegroundColor(source.getForegroundColor());
        this.setModifiers((EnumSet)source.getActiveModifiers());
        return this;
    }
}

