/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.bundle.LanternaThemes;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.BasePane;
import com.googlecode.lanterna.gui2.Border;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.Container;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.TextGUIGraphics;

public abstract class AbstractComponent<T extends Component>
implements Component {
    private ComponentRenderer<T> overrideRenderer = null;
    private ComponentRenderer<T> themeRenderer = null;
    private Theme themeRenderersTheme = null;
    private ComponentRenderer<T> defaultRenderer = null;
    private Container parent = null;
    private TerminalSize size = TerminalSize.ZERO;
    private TerminalSize explicitPreferredSize = null;
    private TerminalPosition position = TerminalPosition.TOP_LEFT_CORNER;
    private Theme themeOverride;
    private LayoutData layoutData = null;
    private boolean visible = true;
    private boolean invalid = true;

    protected abstract ComponentRenderer<T> createDefaultRenderer();

    protected void runOnGUIThreadIfExistsOtherwiseRunDirect(Runnable runnable) {
        if (this.getTextGUI() != null && this.getTextGUI().getGUIThread() != null) {
            this.getTextGUI().getGUIThread().invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    public T setRenderer(ComponentRenderer<T> renderer) {
        this.overrideRenderer = renderer;
        return this.self();
    }

    public synchronized ComponentRenderer<T> getRenderer() {
        if (this.overrideRenderer != null) {
            return this.overrideRenderer;
        }
        Theme currentTheme = this.getTheme();
        if (this.themeRenderer == null && this.getBasePane() != null || this.themeRenderer != null && currentTheme != this.themeRenderersTheme) {
            this.themeRenderer = currentTheme.getDefinition(this.getClass()).getRenderer(this.selfClass());
            if (this.themeRenderer != null) {
                this.themeRenderersTheme = currentTheme;
            }
        }
        if (this.themeRenderer != null) {
            return this.themeRenderer;
        }
        if (this.defaultRenderer == null) {
            this.defaultRenderer = this.createDefaultRenderer();
            if (this.defaultRenderer == null) {
                throw new IllegalStateException(this.getClass() + " returned a null default renderer");
            }
        }
        return this.defaultRenderer;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }

    public synchronized T setSize(TerminalSize size) {
        this.size = size;
        return this.self();
    }

    @Override
    public TerminalSize getSize() {
        return this.size;
    }

    @Override
    public final TerminalSize getPreferredSize() {
        if (this.explicitPreferredSize != null) {
            return this.explicitPreferredSize;
        }
        return this.calculatePreferredSize();
    }

    public final synchronized T setPreferredSize(TerminalSize explicitPreferredSize) {
        this.explicitPreferredSize = explicitPreferredSize;
        return this.self();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public T setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            if (visible) {
                this.invalidate();
            } else {
                Container parent = this.getParent();
                if (parent != null) {
                    parent.invalidate();
                }
            }
        }
        return this.self();
    }

    protected synchronized TerminalSize calculatePreferredSize() {
        return this.getRenderer().getPreferredSize(this.self());
    }

    public synchronized T setPosition(TerminalPosition position) {
        this.position = position;
        return this.self();
    }

    @Override
    public TerminalPosition getPosition() {
        return this.position;
    }

    @Override
    public TerminalPosition getGlobalPosition() {
        return this.toGlobal(TerminalPosition.TOP_LEFT_CORNER);
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public final synchronized void draw(TextGUIGraphics graphics) {
        this.setSize(graphics.getSize());
        this.onBeforeDrawing();
        this.getRenderer().drawComponent(graphics, this.self());
        this.onAfterDrawing(graphics);
        this.invalid = false;
    }

    protected void onBeforeDrawing() {
    }

    protected void onAfterDrawing(TextGUIGraphics graphics) {
    }

    public synchronized T setLayoutData(LayoutData data) {
        if (this.layoutData != data) {
            this.layoutData = data;
            this.invalidate();
        }
        return this.self();
    }

    @Override
    public LayoutData getLayoutData() {
        return this.layoutData;
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public boolean hasParent(Container parent) {
        if (this.parent == null) {
            return false;
        }
        for (Container recursiveParent = this.parent; recursiveParent != null; recursiveParent = recursiveParent.getParent()) {
            if (recursiveParent != parent) continue;
            return true;
        }
        return false;
    }

    @Override
    public TextGUI getTextGUI() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getTextGUI();
    }

    @Override
    public synchronized Theme getTheme() {
        if (this.themeOverride != null) {
            return this.themeOverride;
        }
        if (this.parent != null) {
            return this.parent.getTheme();
        }
        if (this.getBasePane() != null) {
            return this.getBasePane().getTheme();
        }
        return LanternaThemes.getDefaultTheme();
    }

    @Override
    public ThemeDefinition getThemeDefinition() {
        return this.getTheme().getDefinition(this.getClass());
    }

    @Override
    public synchronized Component setTheme(Theme theme) {
        this.themeOverride = theme;
        this.invalidate();
        return this;
    }

    @Override
    public boolean isInside(Container container) {
        Component test = this;
        while (test.getParent() != null) {
            if (test.getParent() == container) {
                return true;
            }
            test = test.getParent();
        }
        return false;
    }

    @Override
    public BasePane getBasePane() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getBasePane();
    }

    @Override
    public TerminalPosition toBasePane(TerminalPosition position) {
        Container parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.toBasePane(this.getPosition().withRelative(position));
    }

    @Override
    public TerminalPosition toGlobal(TerminalPosition position) {
        Container parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.toGlobal(this.getPosition().withRelative(position));
    }

    @Override
    public synchronized Border withBorder(Border border) {
        border.setComponent(this);
        return border;
    }

    public synchronized T addTo(Panel panel) {
        panel.addComponent(this);
        return this.self();
    }

    @Override
    public synchronized void onAdded(Container container) {
        if (this.parent != container && this.parent != null) {
            this.parent.removeComponent(this);
        }
        this.parent = container;
    }

    @Override
    public synchronized void onRemoved(Container container) {
        if (this.parent != container) {
            throw new IllegalStateException(this + " is not " + container + "'s child.");
        }
        this.parent = null;
        this.themeRenderer = null;
    }

    protected T self() {
        return (T)this;
    }

    private Class<T> selfClass() {
        return this.getClass();
    }
}

