/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.screen.TerminalScreen;
import com.googlecode.lanterna.terminal.MouseCaptureMode;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalFactory;
import com.googlecode.lanterna.terminal.ansi.CygwinTerminal;
import com.googlecode.lanterna.terminal.ansi.TelnetTerminal;
import com.googlecode.lanterna.terminal.ansi.TelnetTerminalServer;
import com.googlecode.lanterna.terminal.ansi.UnixLikeTerminal;
import com.googlecode.lanterna.terminal.ansi.UnixTerminal;
import com.googlecode.lanterna.terminal.swing.AWTTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.AWTTerminalFrame;
import com.googlecode.lanterna.terminal.swing.SwingTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.SwingTerminalFrame;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorAutoCloseTrigger;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorColorConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorDeviceConfiguration;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.EnumSet;

public class DefaultTerminalFactory
implements TerminalFactory {
    private static final OutputStream DEFAULT_OUTPUT_STREAM = System.out;
    private static final InputStream DEFAULT_INPUT_STREAM = System.in;
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private final OutputStream outputStream;
    private final InputStream inputStream;
    private final Charset charset;
    private TerminalSize initialTerminalSize;
    private boolean forceTextTerminal;
    private boolean preferTerminalEmulator;
    private boolean forceAWTOverSwing;
    private int telnetPort;
    private int inputTimeout;
    private String title;
    private boolean autoOpenTerminalFrame;
    private final EnumSet<TerminalEmulatorAutoCloseTrigger> autoCloseTriggers;
    private TerminalEmulatorColorConfiguration colorConfiguration;
    private TerminalEmulatorDeviceConfiguration deviceConfiguration;
    private AWTTerminalFontConfiguration fontConfiguration;
    private MouseCaptureMode mouseCaptureMode;
    private UnixLikeTerminal.CtrlCBehaviour unixTerminalCtrlCBehaviour;

    public DefaultTerminalFactory() {
        this(DEFAULT_OUTPUT_STREAM, DEFAULT_INPUT_STREAM, DEFAULT_CHARSET);
    }

    public DefaultTerminalFactory(OutputStream outputStream, InputStream inputStream, Charset charset) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
        this.charset = charset;
        this.forceTextTerminal = false;
        this.preferTerminalEmulator = false;
        this.forceAWTOverSwing = false;
        this.telnetPort = -1;
        this.inputTimeout = -1;
        this.autoOpenTerminalFrame = true;
        this.title = null;
        this.autoCloseTriggers = EnumSet.of(TerminalEmulatorAutoCloseTrigger.CloseOnExitPrivateMode);
        this.mouseCaptureMode = null;
        this.unixTerminalCtrlCBehaviour = UnixLikeTerminal.CtrlCBehaviour.CTRL_C_KILLS_APPLICATION;
        this.colorConfiguration = null;
        this.deviceConfiguration = null;
        this.fontConfiguration = null;
    }

    @Override
    public Terminal createTerminal() throws IOException {
        if (this.forceTextTerminal || this.isAwtHeadless() || System.console() != null && !this.preferTerminalEmulator) {
            return this.createHeadlessTerminal();
        }
        if (!this.preferTerminalEmulator && this.mouseCaptureMode != null && this.telnetPort > 0) {
            return this.createTelnetTerminal();
        }
        return this.createTerminalEmulator();
    }

    public Terminal createHeadlessTerminal() throws IOException {
        if (this.telnetPort > 0 && System.console() == null) {
            return this.createTelnetTerminal();
        }
        if (DefaultTerminalFactory.isOperatingSystemWindows()) {
            return this.createWindowsTerminal();
        }
        return this.createUnixTerminal(this.outputStream, this.inputStream, this.charset);
    }

    public Terminal createTerminalEmulator() {
        Frame terminal = !this.forceAWTOverSwing && this.hasSwing() ? this.createSwingTerminal() : this.createAWTTerminal();
        if (this.autoOpenTerminalFrame) {
            this.makeWindowVisible((Terminal)((Object)terminal));
        }
        return terminal;
    }

    public AWTTerminalFrame createAWTTerminal() {
        return new AWTTerminalFrame(this.title, this.initialTerminalSize, this.deviceConfiguration, this.fontConfiguration, this.colorConfiguration, this.autoCloseTriggers.toArray(new TerminalEmulatorAutoCloseTrigger[0]));
    }

    public SwingTerminalFrame createSwingTerminal() {
        return new SwingTerminalFrame(this.title, this.initialTerminalSize, this.deviceConfiguration, this.fontConfiguration instanceof SwingTerminalFontConfiguration ? (SwingTerminalFontConfiguration)this.fontConfiguration : null, this.colorConfiguration, this.autoCloseTriggers.toArray(new TerminalEmulatorAutoCloseTrigger[0]));
    }

    public TelnetTerminal createTelnetTerminal() {
        try {
            System.err.print("Waiting for incoming telnet connection on port " + this.telnetPort + " ... ");
            System.err.flush();
            TelnetTerminalServer tts = new TelnetTerminalServer(this.telnetPort);
            TelnetTerminal rawTerminal = tts.acceptConnection();
            tts.close();
            System.err.println("Ok, got it!");
            if (this.mouseCaptureMode != null) {
                rawTerminal.setMouseCaptureMode(this.mouseCaptureMode);
            }
            if (this.inputTimeout >= 0) {
                rawTerminal.getInputDecoder().setTimeoutUnits(this.inputTimeout);
            }
            return rawTerminal;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private boolean isAwtHeadless() {
        try {
            Class<?> cls = Class.forName("java.awt.GraphicsEnvironment");
            Method method = cls.getDeclaredMethod("isHeadless", new Class[0]);
            return (Boolean)method.invoke(null, new Object[0]);
        }
        catch (Exception ignore) {
            return true;
        }
    }

    private boolean hasSwing() {
        try {
            Class.forName("javax.swing.JComponent");
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    private void makeWindowVisible(Terminal terminal) {
        try {
            Class<?> cls = Class.forName("java.awt.Window");
            Method method = cls.getDeclaredMethod("setVisible", Boolean.TYPE);
            method.invoke((Object)terminal, true);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to make terminal emulator window visible.", ex);
        }
    }

    public DefaultTerminalFactory setInitialTerminalSize(TerminalSize initialTerminalSize) {
        this.initialTerminalSize = initialTerminalSize;
        return this;
    }

    public DefaultTerminalFactory setForceTextTerminal(boolean forceTextTerminal) {
        this.forceTextTerminal = forceTextTerminal;
        return this;
    }

    public DefaultTerminalFactory setPreferTerminalEmulator(boolean preferTerminalEmulator) {
        this.preferTerminalEmulator = preferTerminalEmulator;
        return this;
    }

    public DefaultTerminalFactory setUnixTerminalCtrlCBehaviour(UnixLikeTerminal.CtrlCBehaviour unixTerminalCtrlCBehaviour) {
        this.unixTerminalCtrlCBehaviour = unixTerminalCtrlCBehaviour;
        return this;
    }

    public DefaultTerminalFactory setTelnetPort(int telnetPort) {
        this.telnetPort = telnetPort;
        return this;
    }

    public DefaultTerminalFactory setInputTimeout(int inputTimeout) {
        this.inputTimeout = inputTimeout;
        return this;
    }

    public DefaultTerminalFactory setForceAWTOverSwing(boolean forceAWTOverSwing) {
        this.forceAWTOverSwing = forceAWTOverSwing;
        return this;
    }

    public DefaultTerminalFactory setAutoOpenTerminalEmulatorWindow(boolean autoOpenTerminalFrame) {
        this.autoOpenTerminalFrame = autoOpenTerminalFrame;
        return this;
    }

    public DefaultTerminalFactory setTerminalEmulatorTitle(String title) {
        this.title = title;
        return this;
    }

    public DefaultTerminalFactory setTerminalEmulatorFrameAutoCloseTrigger(TerminalEmulatorAutoCloseTrigger autoCloseTrigger) {
        this.autoCloseTriggers.clear();
        if (autoCloseTrigger != null) {
            this.autoCloseTriggers.add(autoCloseTrigger);
        }
        return this;
    }

    public DefaultTerminalFactory addTerminalEmulatorFrameAutoCloseTrigger(TerminalEmulatorAutoCloseTrigger autoCloseTrigger) {
        if (autoCloseTrigger != null) {
            this.autoCloseTriggers.add(autoCloseTrigger);
        }
        return this;
    }

    public DefaultTerminalFactory setTerminalEmulatorColorConfiguration(TerminalEmulatorColorConfiguration colorConfiguration) {
        this.colorConfiguration = colorConfiguration;
        return this;
    }

    public DefaultTerminalFactory setTerminalEmulatorDeviceConfiguration(TerminalEmulatorDeviceConfiguration deviceConfiguration) {
        this.deviceConfiguration = deviceConfiguration;
        return this;
    }

    public DefaultTerminalFactory setTerminalEmulatorFontConfiguration(AWTTerminalFontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
        return this;
    }

    public DefaultTerminalFactory setMouseCaptureMode(MouseCaptureMode mouseCaptureMode) {
        this.mouseCaptureMode = mouseCaptureMode;
        return this;
    }

    public TerminalScreen createScreen() throws IOException {
        return new TerminalScreen(this.createTerminal());
    }

    private Terminal createWindowsTerminal() throws IOException {
        try {
            Class<?> nativeImplementation = Class.forName("com.googlecode.lanterna.terminal.WindowsTerminal");
            Constructor<?> constructor = nativeImplementation.getConstructor(InputStream.class, OutputStream.class, Charset.class, UnixLikeTerminal.CtrlCBehaviour.class);
            return (Terminal)constructor.newInstance(new Object[]{this.inputStream, this.outputStream, this.charset, UnixLikeTerminal.CtrlCBehaviour.CTRL_C_KILLS_APPLICATION});
        }
        catch (Exception ignore) {
            try {
                return this.createCygwinTerminal(this.outputStream, this.inputStream, this.charset);
            }
            catch (IOException e) {
                throw new IOException("To start java on Windows, use javaw! (see https://github.com/mabe02/lanterna/issues/335 )", e);
            }
        }
    }

    private Terminal createCygwinTerminal(OutputStream outputStream, InputStream inputStream, Charset charset) throws IOException {
        CygwinTerminal cygTerminal = new CygwinTerminal(inputStream, outputStream, charset);
        if (this.inputTimeout >= 0) {
            cygTerminal.getInputDecoder().setTimeoutUnits(this.inputTimeout);
        }
        return cygTerminal;
    }

    private Terminal createUnixTerminal(OutputStream outputStream, InputStream inputStream, Charset charset) throws IOException {
        UnixTerminal unixTerminal;
        try {
            Class<?> nativeImplementation = Class.forName("com.googlecode.lanterna.terminal.NativeGNULinuxTerminal");
            Constructor<?> constructor = nativeImplementation.getConstructor(InputStream.class, OutputStream.class, Charset.class, UnixLikeTerminal.CtrlCBehaviour.class);
            unixTerminal = (UnixTerminal)constructor.newInstance(new Object[]{inputStream, outputStream, charset, this.unixTerminalCtrlCBehaviour});
        }
        catch (Exception ignore) {
            unixTerminal = new UnixTerminal(inputStream, outputStream, charset, this.unixTerminalCtrlCBehaviour);
        }
        if (this.mouseCaptureMode != null) {
            unixTerminal.setMouseCaptureMode(this.mouseCaptureMode);
        }
        if (this.inputTimeout >= 0) {
            unixTerminal.getInputDecoder().setTimeoutUnits(this.inputTimeout);
        }
        return unixTerminal;
    }

    private static boolean isOperatingSystemWindows() {
        return System.getProperty("os.name", "").toLowerCase().startsWith("windows");
    }
}

