/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.backup.core;

import de.toxicfox.backup.core.Session;
import java.io.File;
import java.io.IOException;
import net.shadew.json.Json;
import net.shadew.json.JsonNode;

public class SessionStore {
    private final File sessionDirectory;
    private final File sessionFile;
    private final Json json = Json.json();
    private JsonNode sessionsStore;

    public SessionStore(File sessionDirectory) throws IOException {
        this.sessionDirectory = sessionDirectory;
        this.sessionFile = new File(sessionDirectory, "sessions.json");
        this.sessionDirectory.mkdirs();
        this.load();
    }

    public void load() throws IOException {
        if (this.sessionFile.exists()) {
            this.sessionsStore = this.json.parse(this.sessionFile);
        } else {
            this.sessionsStore = JsonNode.object().set("sessions", JsonNode.array());
            this.save();
        }
    }

    public void save() throws IOException {
        this.json.serialize(this.sessionsStore, this.sessionFile);
    }

    public void persistSession(Session session) {
        this.sessionsStore.get("sessions").add(session.getTimestamp());
        try {
            this.json.serialize(session.toJSON(), new File(this.sessionDirectory, session.getTimestamp() + ".json"));
            this.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Session loadLatestSession() {
        JsonNode sessions = this.sessionsStore.get("sessions");
        if (sessions.size() == 0) {
            return new Session();
        }
        long session = sessions.get(sessions.size() - 1).asLong();
        return SessionStore.loadFromSessionFile(new File(this.sessionDirectory, session + ".json"));
    }

    public static Session loadFromSessionFile(File file) {
        try {
            return Session.fromJSON(Json.json().parse(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

