/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.backup.core;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;

public class ThreadPool {
    private final ArrayList<Thread> threads = new ArrayList();
    private final Stack<Runnable> tasks = new Stack();
    private boolean running = true;
    private int maxQueueSize = 100;

    public ThreadPool(int size) {
        this.startThreads(size);
    }

    public ThreadPool() {
        String maxThreadsStr = System.getenv("MAX_THREADS");
        int maxThreads = 32;
        if (maxThreadsStr != null) {
            try {
                maxThreads = Integer.parseInt(maxThreadsStr);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid MAX_THREADS: " + maxThreads);
            }
        }
        this.startThreads(maxThreads);
    }

    private void startThreads(int size) {
        for (int i = 0; i < size; ++i) {
            Thread thread = new Thread(this::poll);
            this.threads.add(thread);
            thread.start();
        }
    }

    public void submit(Runnable task) {
        if (!this.running) {
            throw new IllegalStateException("Thread pool is not running");
        }
        while (this.tasks.size() > this.maxQueueSize) {
            this.safeSleep(1);
        }
        this.tasks.push(task);
    }

    private void poll() {
        while (this.running) {
            try {
                Runnable task = this.tasks.pop();
                task.run();
            }
            catch (EmptyStackException e) {
                this.safeSleep(100);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        while (!this.tasks.isEmpty()) {
            this.safeSleep(100);
        }
        this.running = false;
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void safeSleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

