/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.config.auto.processors;

import de.toxicfox.config.Savable;
import de.toxicfox.config.auto.JsonProcessor;
import net.shadew.json.JsonNode;

public class SavableArrayProcessor
implements JsonProcessor {
    private final SavableConstructorReference base;
    private final SavableArrayConstructorReference array;

    public SavableArrayProcessor(SavableConstructorReference base, SavableArrayConstructorReference array) {
        this.base = base;
        this.array = array;
    }

    @Override
    public JsonNode toJson(Object obj) {
        JsonNode objectArray = JsonNode.array();
        for (Savable s : (Savable[])obj) {
            objectArray.add(s.toJSON());
        }
        return objectArray;
    }

    @Override
    public Object fromJson(JsonNode node, Object obj, boolean optional) {
        if (node == null || node.isNull()) {
            if (optional) {
                return obj;
            }
            throw new RuntimeException("Missing field");
        }
        Savable[] result = this.array.create(node.size());
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.base.create();
            result[i].fromJSON(node.get(i));
        }
        return result;
    }

    public static interface SavableConstructorReference {
        public Savable create();
    }

    public static interface SavableArrayConstructorReference {
        public Savable[] create(int var1);
    }
}

