/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.shadew.json.IncorrectSizeException;
import net.shadew.json.IncorrectTypeException;
import net.shadew.json.JsonNode;
import net.shadew.json.JsonPath;
import net.shadew.json.JsonType;

public abstract class AbstractJsonNode
implements JsonNode {
    private final JsonType type;

    protected AbstractJsonNode(JsonType type) {
        this.type = type;
    }

    private static void require(int i, JsonNode node, JsonType type) {
        if (!node.is(type)) {
            throw new IncorrectTypeException(i, node.type(), type);
        }
    }

    @Override
    public JsonType type() {
        return this.type;
    }

    @Override
    public boolean isNull() {
        return this.is(JsonType.NULL);
    }

    @Override
    public boolean isString() {
        return this.is(JsonType.STRING);
    }

    @Override
    public boolean isNumber() {
        return this.is(JsonType.NUMBER);
    }

    @Override
    public boolean isBoolean() {
        return this.is(JsonType.BOOLEAN);
    }

    @Override
    public boolean isObject() {
        return this.is(JsonType.OBJECT);
    }

    @Override
    public boolean isArray() {
        return this.is(JsonType.ARRAY);
    }

    @Override
    public boolean is(JsonType type) {
        return type == this.type;
    }

    @Override
    public boolean is(JsonType ... types) {
        for (JsonType type : types) {
            if (!this.is(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JsonNode requireNull() {
        this.require(JsonType.NULL);
        return this;
    }

    @Override
    public JsonNode requireNotNull() {
        this.requireNot(JsonType.NULL);
        return this;
    }

    @Override
    public JsonNode requireString() {
        this.require(JsonType.STRING);
        return this;
    }

    @Override
    public JsonNode requireNotString() {
        this.requireNot(JsonType.STRING);
        return this;
    }

    @Override
    public JsonNode requireNumber() {
        this.require(JsonType.NUMBER);
        return this;
    }

    @Override
    public JsonNode requireNotNumber() {
        this.requireNot(JsonType.NUMBER);
        return this;
    }

    @Override
    public JsonNode requireBoolean() {
        this.require(JsonType.BOOLEAN);
        return this;
    }

    @Override
    public JsonNode requireNotBoolean() {
        this.requireNot(JsonType.BOOLEAN);
        return this;
    }

    @Override
    public JsonNode requireObject() {
        this.require(JsonType.OBJECT);
        return this;
    }

    @Override
    public JsonNode requireNotObject() {
        this.requireNot(JsonType.OBJECT);
        return this;
    }

    @Override
    public JsonNode requireArray() {
        this.require(JsonType.ARRAY);
        return this;
    }

    @Override
    public JsonNode requireNotArray() {
        this.requireNot(JsonType.ARRAY);
        return this;
    }

    @Override
    public JsonNode require(JsonType type) {
        if (!this.is(type)) {
            throw new IncorrectTypeException(this.type, type);
        }
        return this;
    }

    @Override
    public JsonNode requireNot(JsonType type) {
        if (this.is(type)) {
            throw new IncorrectTypeException(this.type, JsonType.allExcluding0(type));
        }
        return this;
    }

    @Override
    public JsonNode require(JsonType ... types) {
        if (!this.is(types)) {
            throw new IncorrectTypeException(this.type, types);
        }
        return this;
    }

    @Override
    public JsonNode requireNot(JsonType ... types) {
        if (this.is(types)) {
            throw new IncorrectTypeException(null, this.type, types);
        }
        return this;
    }

    @Override
    public JsonNode ifString(BiConsumer<JsonNode, String> action) {
        return this;
    }

    @Override
    public JsonNode ifNumber(BiConsumer<JsonNode, Number> action) {
        return this;
    }

    @Override
    public JsonNode ifByte(BiConsumer<JsonNode, Byte> action) {
        return this;
    }

    @Override
    public JsonNode ifShort(BiConsumer<JsonNode, Short> action) {
        return this;
    }

    @Override
    public JsonNode ifInt(BiConsumer<JsonNode, Integer> action) {
        return this;
    }

    @Override
    public JsonNode ifLong(BiConsumer<JsonNode, Long> action) {
        return this;
    }

    @Override
    public JsonNode ifFloat(BiConsumer<JsonNode, Float> action) {
        return this;
    }

    @Override
    public JsonNode ifDouble(BiConsumer<JsonNode, Double> action) {
        return this;
    }

    @Override
    public JsonNode ifBigInteger(BiConsumer<JsonNode, BigInteger> action) {
        return this;
    }

    @Override
    public JsonNode ifBigDecimal(BiConsumer<JsonNode, BigDecimal> action) {
        return this;
    }

    @Override
    public JsonNode ifBoolean(BiConsumer<JsonNode, Boolean> action) {
        return this;
    }

    @Override
    public JsonNode ifNull(Consumer<JsonNode> action) {
        return this;
    }

    @Override
    public JsonNode ifArray(Consumer<JsonNode> action) {
        return this;
    }

    @Override
    public JsonNode ifObject(Consumer<JsonNode> action) {
        return this;
    }

    @Override
    public JsonNode ifPrimitive(Consumer<JsonNode> action) {
        return this;
    }

    @Override
    public JsonNode ifConstruct(Consumer<JsonNode> action) {
        return this;
    }

    @Override
    public String[] asStringArray() {
        this.requireArray();
        int l = this.size();
        String[] arr = new String[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.STRING);
            arr[i] = this.get(i).asExactString();
        }
        return arr;
    }

    @Override
    public byte[] asByteArray() {
        this.requireArray();
        int l = this.size();
        byte[] arr = new byte[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.NUMBER);
            arr[i] = this.get(i).asByte();
        }
        return arr;
    }

    @Override
    public short[] asShortArray() {
        this.requireArray();
        int l = this.size();
        short[] arr = new short[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.NUMBER);
            arr[i] = this.get(i).asShort();
        }
        return arr;
    }

    @Override
    public int[] asIntArray() {
        this.requireArray();
        int l = this.size();
        int[] arr = new int[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.NUMBER);
            arr[i] = this.get(i).asInt();
        }
        return arr;
    }

    @Override
    public long[] asLongArray() {
        this.requireArray();
        int l = this.size();
        long[] arr = new long[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.NUMBER);
            arr[i] = this.get(i).asLong();
        }
        return arr;
    }

    @Override
    public float[] asFloatArray() {
        this.requireArray();
        int l = this.size();
        float[] arr = new float[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.NUMBER);
            arr[i] = this.get(i).asFloat();
        }
        return arr;
    }

    @Override
    public double[] asDoubleArray() {
        this.requireArray();
        int l = this.size();
        double[] arr = new double[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.NUMBER);
            arr[i] = this.get(i).asDouble();
        }
        return arr;
    }

    @Override
    public BigInteger[] asBigIntegerArray() {
        this.requireArray();
        int l = this.size();
        BigInteger[] arr = new BigInteger[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.NUMBER);
            arr[i] = this.get(i).asBigInteger();
        }
        return arr;
    }

    @Override
    public BigDecimal[] asBigDecimalArray() {
        this.requireArray();
        int l = this.size();
        BigDecimal[] arr = new BigDecimal[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.NUMBER);
            arr[i] = this.get(i).asBigDecimal();
        }
        return arr;
    }

    @Override
    public Number[] asNumberArray() {
        this.requireArray();
        int l = this.size();
        Number[] arr = new Number[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.NUMBER);
            arr[i] = this.get(i).asNumber();
        }
        return arr;
    }

    @Override
    public boolean[] asBooleanArray() {
        this.requireArray();
        int l = this.size();
        boolean[] arr = new boolean[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, JsonType.BOOLEAN);
            arr[i] = this.get(i).asBoolean();
        }
        return arr;
    }

    @Override
    public JsonNode requireSize(int length) {
        this.require(JsonType.ARRAY, JsonType.OBJECT);
        int s = this.size();
        if (s != length) {
            throw new IncorrectSizeException(s, length);
        }
        return this;
    }

    @Override
    public String[] asStringArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asStringArray();
    }

    @Override
    public byte[] asByteArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asByteArray();
    }

    @Override
    public short[] asShortArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asShortArray();
    }

    @Override
    public int[] asIntArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asIntArray();
    }

    @Override
    public long[] asLongArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asLongArray();
    }

    @Override
    public float[] asFloatArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asFloatArray();
    }

    @Override
    public double[] asDoubleArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asDoubleArray();
    }

    @Override
    public BigInteger[] asBigIntegerArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asBigIntegerArray();
    }

    @Override
    public BigDecimal[] asBigDecimalArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asBigDecimalArray();
    }

    @Override
    public Number[] asNumberArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asNumberArray();
    }

    @Override
    public boolean[] asBooleanArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asBooleanArray();
    }

    @Override
    public List<JsonNode> asList() {
        throw new IncorrectTypeException(this.type, JsonType.ARRAY);
    }

    @Override
    public Map<String, JsonNode> asMap() {
        throw new IncorrectTypeException(this.type, JsonType.OBJECT);
    }

    @Override
    public JsonNode query(String path) {
        return this.query(JsonPath.parse(path));
    }

    @Override
    public JsonNode query(JsonPath path) {
        return path.query(this);
    }
}

