/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shadew.json.JsonException;
import net.shadew.json.JsonType;

public class IncorrectTypeException
extends JsonException {
    public IncorrectTypeException() {
    }

    public IncorrectTypeException(String message) {
        super(message);
    }

    public IncorrectTypeException(String message, Throwable cause) {
        super(message, cause);
    }

    public IncorrectTypeException(Throwable cause) {
        super(cause);
    }

    public IncorrectTypeException(JsonType found, JsonType ... required) {
        super(IncorrectTypeException.makeMessage(found, required));
    }

    public IncorrectTypeException(int index, JsonType found, JsonType ... required) {
        super(IncorrectTypeException.makeMessage(index, found, required));
    }

    IncorrectTypeException(Void invertMark, JsonType found, JsonType ... prohibited) {
        super(IncorrectTypeException.makeMessageInv(found, prohibited));
    }

    private static String makeMessage(JsonType found, JsonType ... required) {
        return String.format("Unmatched types, required %s, found %s", new Object[]{Stream.of(required).map(Enum::name).collect(Collectors.joining(", ")), found});
    }

    private static String makeMessageInv(JsonType found, JsonType ... prohibited) {
        HashSet<JsonType> types = new HashSet<JsonType>(Arrays.asList(prohibited));
        Object[] objectArray = new Object[2];
        objectArray[0] = Stream.of(JsonType.VALUES).filter(types::contains).map(Enum::name).collect(Collectors.joining(", "));
        objectArray[1] = found;
        return String.format("Unmatched types, required %s, found %s", objectArray);
    }

    private static String makeMessage(int index, JsonType found, JsonType ... required) {
        return String.format("Unmatched types for index %d of array, required %s, found %s", new Object[]{index, Stream.of(required).map(Enum::name).collect(Collectors.joining(", ")), found});
    }
}

