/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna;

import java.awt.Color;
import java.io.Serializable;
import java.util.regex.Pattern;

public interface TextColor
extends Serializable {
    public byte[] getForegroundSGRSequence();

    public byte[] getBackgroundSGRSequence();

    public int getRed();

    public int getGreen();

    public int getBlue();

    @Deprecated
    public Color toColor();

    public static class Factory {
        private static final Pattern INDEXED_COLOR = Pattern.compile("#[0-9]{1,3}");
        private static final Pattern RGB_COLOR = Pattern.compile("#[0-9a-fA-F]{6}");

        private Factory() {
        }

        public static TextColor fromString(String value) {
            if (value == null) {
                return null;
            }
            if (RGB_COLOR.matcher(value = value.trim()).matches()) {
                int r = Integer.parseInt(value.substring(1, 3), 16);
                int g = Integer.parseInt(value.substring(3, 5), 16);
                int b = Integer.parseInt(value.substring(5, 7), 16);
                return new RGB(r, g, b);
            }
            if (INDEXED_COLOR.matcher(value).matches()) {
                int index = Integer.parseInt(value.substring(1));
                return new Indexed(index);
            }
            try {
                return ANSI.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unknown color definition \"" + value + "\"", e);
            }
        }
    }

    public static class RGB
    implements TextColor {
        private final int red;
        private final int green;
        private final int blue;

        public RGB(int r, int g, int b) {
            if (r < 0 || r > 255) {
                throw new IllegalArgumentException("RGB: r is outside of valid range (0-255)");
            }
            if (g < 0 || g > 255) {
                throw new IllegalArgumentException("RGB: g is outside of valid range (0-255)");
            }
            if (b < 0 || b > 255) {
                throw new IllegalArgumentException("RGB: b is outside of valid range (0-255)");
            }
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        @Override
        public byte[] getForegroundSGRSequence() {
            return ("38;2;" + this.getRed() + ";" + this.getGreen() + ";" + this.getBlue()).getBytes();
        }

        @Override
        public byte[] getBackgroundSGRSequence() {
            return ("48;2;" + this.getRed() + ";" + this.getGreen() + ";" + this.getBlue()).getBytes();
        }

        @Override
        public int getRed() {
            return this.red;
        }

        @Override
        public int getGreen() {
            return this.green;
        }

        @Override
        public int getBlue() {
            return this.blue;
        }

        @Override
        public Color toColor() {
            return new Color(this.getRed(), this.getGreen(), this.getBlue());
        }

        public String toString() {
            return "{RGB:" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + "}";
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + this.red;
            hash = 29 * hash + this.green;
            hash = 29 * hash + this.blue;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RGB other = (RGB)obj;
            return this.red == other.red && this.green == other.green && this.blue == other.blue;
        }
    }

    public static class Indexed
    implements TextColor {
        private static final byte[][] COLOR_TABLE = new byte[][]{{0, 0, 0}, {-86, 0, 0}, {0, -86, 0}, {-86, 85, 0}, {0, 0, -86}, {-86, 0, -86}, {0, -86, -86}, {-86, -86, -86}, {85, 85, 85}, {-1, 85, 85}, {85, -1, 85}, {-1, -1, 85}, {85, 85, -1}, {-1, 85, -1}, {85, -1, -1}, {-1, -1, -1}, {0, 0, 0}, {0, 0, 95}, {0, 0, -121}, {0, 0, -81}, {0, 0, -41}, {0, 0, -1}, {0, 95, 0}, {0, 95, 95}, {0, 95, -121}, {0, 95, -81}, {0, 95, -41}, {0, 95, -1}, {0, -121, 0}, {0, -121, 95}, {0, -121, -121}, {0, -121, -81}, {0, -121, -41}, {0, -121, -1}, {0, -81, 0}, {0, -81, 95}, {0, -81, -121}, {0, -81, -81}, {0, -81, -41}, {0, -81, -1}, {0, -41, 0}, {0, -41, 95}, {0, -41, -121}, {0, -41, -81}, {0, -41, -41}, {0, -41, -1}, {0, -1, 0}, {0, -1, 95}, {0, -1, -121}, {0, -1, -81}, {0, -1, -41}, {0, -1, -1}, {95, 0, 0}, {95, 0, 95}, {95, 0, -121}, {95, 0, -81}, {95, 0, -41}, {95, 0, -1}, {95, 95, 0}, {95, 95, 95}, {95, 95, -121}, {95, 95, -81}, {95, 95, -41}, {95, 95, -1}, {95, -121, 0}, {95, -121, 95}, {95, -121, -121}, {95, -121, -81}, {95, -121, -41}, {95, -121, -1}, {95, -81, 0}, {95, -81, 95}, {95, -81, -121}, {95, -81, -81}, {95, -81, -41}, {95, -81, -1}, {95, -41, 0}, {95, -41, 95}, {95, -41, -121}, {95, -41, -81}, {95, -41, -41}, {95, -41, -1}, {95, -1, 0}, {95, -1, 95}, {95, -1, -121}, {95, -1, -81}, {95, -1, -41}, {95, -1, -1}, {-121, 0, 0}, {-121, 0, 95}, {-121, 0, -121}, {-121, 0, -81}, {-121, 0, -41}, {-121, 0, -1}, {-121, 95, 0}, {-121, 95, 95}, {-121, 95, -121}, {-121, 95, -81}, {-121, 95, -41}, {-121, 95, -1}, {-121, -121, 0}, {-121, -121, 95}, {-121, -121, -121}, {-121, -121, -81}, {-121, -121, -41}, {-121, -121, -1}, {-121, -81, 0}, {-121, -81, 95}, {-121, -81, -121}, {-121, -81, -81}, {-121, -81, -41}, {-121, -81, -1}, {-121, -41, 0}, {-121, -41, 95}, {-121, -41, -121}, {-121, -41, -81}, {-121, -41, -41}, {-121, -41, -1}, {-121, -1, 0}, {-121, -1, 95}, {-121, -1, -121}, {-121, -1, -81}, {-121, -1, -41}, {-121, -1, -1}, {-81, 0, 0}, {-81, 0, 95}, {-81, 0, -121}, {-81, 0, -81}, {-81, 0, -41}, {-81, 0, -1}, {-81, 95, 0}, {-81, 95, 95}, {-81, 95, -121}, {-81, 95, -81}, {-81, 95, -41}, {-81, 95, -1}, {-81, -121, 0}, {-81, -121, 95}, {-81, -121, -121}, {-81, -121, -81}, {-81, -121, -41}, {-81, -121, -1}, {-81, -81, 0}, {-81, -81, 95}, {-81, -81, -121}, {-81, -81, -81}, {-81, -81, -41}, {-81, -81, -1}, {-81, -41, 0}, {-81, -41, 95}, {-81, -41, -121}, {-81, -41, -81}, {-81, -41, -41}, {-81, -41, -1}, {-81, -1, 0}, {-81, -1, 95}, {-81, -1, -121}, {-81, -1, -81}, {-81, -1, -41}, {-81, -1, -1}, {-41, 0, 0}, {-41, 0, 95}, {-41, 0, -121}, {-41, 0, -81}, {-41, 0, -41}, {-41, 0, -1}, {-41, 95, 0}, {-41, 95, 95}, {-41, 95, -121}, {-41, 95, -81}, {-41, 95, -41}, {-41, 95, -1}, {-41, -121, 0}, {-41, -121, 95}, {-41, -121, -121}, {-41, -121, -81}, {-41, -121, -41}, {-41, -121, -1}, {-41, -81, 0}, {-41, -81, 95}, {-41, -81, -121}, {-41, -81, -81}, {-41, -81, -41}, {-41, -81, -1}, {-41, -41, 0}, {-41, -41, 95}, {-41, -41, -121}, {-41, -41, -81}, {-41, -41, -41}, {-41, -41, -1}, {-41, -1, 0}, {-41, -1, 95}, {-41, -1, -121}, {-41, -1, -81}, {-41, -1, -41}, {-41, -1, -1}, {-1, 0, 0}, {-1, 0, 95}, {-1, 0, -121}, {-1, 0, -81}, {-1, 0, -41}, {-1, 0, -1}, {-1, 95, 0}, {-1, 95, 95}, {-1, 95, -121}, {-1, 95, -81}, {-1, 95, -41}, {-1, 95, -1}, {-1, -121, 0}, {-1, -121, 95}, {-1, -121, -121}, {-1, -121, -81}, {-1, -121, -41}, {-1, -121, -1}, {-1, -81, 0}, {-1, -81, 95}, {-1, -81, -121}, {-1, -81, -81}, {-1, -81, -41}, {-1, -81, -1}, {-1, -41, 0}, {-1, -41, 95}, {-1, -41, -121}, {-1, -41, -81}, {-1, -41, -41}, {-1, -41, -1}, {-1, -1, 0}, {-1, -1, 95}, {-1, -1, -121}, {-1, -1, -81}, {-1, -1, -41}, {-1, -1, -1}, {8, 8, 8}, {18, 18, 18}, {28, 28, 28}, {38, 38, 38}, {48, 48, 48}, {58, 58, 58}, {68, 68, 68}, {78, 78, 78}, {88, 88, 88}, {98, 98, 98}, {108, 108, 108}, {118, 118, 118}, {-128, -128, -128}, {-118, -118, -118}, {-108, -108, -108}, {-98, -98, -98}, {-88, -88, -88}, {-78, -78, -78}, {-68, -68, -68}, {-58, -58, -58}, {-48, -48, -48}, {-38, -38, -38}, {-28, -28, -28}, {-18, -18, -18}};
        private final int colorIndex;

        public Indexed(int colorIndex) {
            if (colorIndex > 255 || colorIndex < 0) {
                throw new IllegalArgumentException("Cannot create a Color.Indexed with a color index of " + colorIndex + ", must be in the range of 0-255");
            }
            this.colorIndex = colorIndex;
        }

        @Override
        public byte[] getForegroundSGRSequence() {
            return ("38;5;" + this.colorIndex).getBytes();
        }

        @Override
        public byte[] getBackgroundSGRSequence() {
            return ("48;5;" + this.colorIndex).getBytes();
        }

        @Override
        public int getRed() {
            return COLOR_TABLE[this.colorIndex][0] & 0xFF;
        }

        @Override
        public int getGreen() {
            return COLOR_TABLE[this.colorIndex][1] & 0xFF;
        }

        @Override
        public int getBlue() {
            return COLOR_TABLE[this.colorIndex][2] & 0xFF;
        }

        @Override
        public Color toColor() {
            return new Color(this.getRed(), this.getGreen(), this.getBlue());
        }

        public String toString() {
            return "{IndexedColor:" + this.colorIndex + "}";
        }

        public int hashCode() {
            int hash = 3;
            hash = 43 * hash + this.colorIndex;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Indexed other = (Indexed)obj;
            return this.colorIndex == other.colorIndex;
        }

        public static Indexed fromRGB(int red, int green, int blue) {
            int greyDistance;
            if (red < 0 || red > 255) {
                throw new IllegalArgumentException("fromRGB: red is outside of valid range (0-255)");
            }
            if (green < 0 || green > 255) {
                throw new IllegalArgumentException("fromRGB: green is outside of valid range (0-255)");
            }
            if (blue < 0 || blue > 255) {
                throw new IllegalArgumentException("fromRGB: blue is outside of valid range (0-255)");
            }
            int rescaledRed = (int)((double)red / 255.0 * 5.0);
            int rescaledGreen = (int)((double)green / 255.0 * 5.0);
            int rescaledBlue = (int)((double)blue / 255.0 * 5.0);
            int index = rescaledBlue + 6 * rescaledGreen + 36 * rescaledRed + 16;
            Indexed fromColorCube = new Indexed(index);
            Indexed fromGreyRamp = Indexed.fromGreyRamp((red + green + blue) / 3);
            int coloredDistance = (red - fromColorCube.getRed()) * (red - fromColorCube.getRed()) + (green - fromColorCube.getGreen()) * (green - fromColorCube.getGreen()) + (blue - fromColorCube.getBlue()) * (blue - fromColorCube.getBlue());
            if (coloredDistance < (greyDistance = (red - fromGreyRamp.getRed()) * (red - fromGreyRamp.getRed()) + (green - fromGreyRamp.getGreen()) * (green - fromGreyRamp.getGreen()) + (blue - fromGreyRamp.getBlue()) * (blue - fromGreyRamp.getBlue()))) {
                return fromColorCube;
            }
            return fromGreyRamp;
        }

        private static Indexed fromGreyRamp(int intensity) {
            int rescaled = (int)((double)intensity / 255.0 * 23.0) + 232;
            return new Indexed(rescaled);
        }
    }

    public static enum ANSI implements TextColor
    {
        BLACK(0, 0, 0, 0),
        RED(1, 170, 0, 0),
        GREEN(2, 0, 170, 0),
        YELLOW(3, 170, 85, 0),
        BLUE(4, 0, 0, 170),
        MAGENTA(5, 170, 0, 170),
        CYAN(6, 0, 170, 170),
        WHITE(7, 170, 170, 170),
        DEFAULT(9, 0, 0, 0),
        BLACK_BRIGHT(0, true, 85, 85, 85),
        RED_BRIGHT(1, true, 255, 85, 85),
        GREEN_BRIGHT(2, true, 85, 255, 85),
        YELLOW_BRIGHT(3, true, 255, 255, 85),
        BLUE_BRIGHT(4, true, 85, 85, 255),
        MAGENTA_BRIGHT(5, true, 255, 85, 255),
        CYAN_BRIGHT(6, true, 85, 255, 255),
        WHITE_BRIGHT(7, true, 255, 255, 255);

        private final boolean bright;
        private final int red;
        private final int green;
        private final int blue;
        private final byte[] foregroundSGR;
        private final byte[] backgroundSGR;

        private ANSI(int index, int red, int green, int blue) {
            this(index, false, red, green, blue);
        }

        private ANSI(int index, boolean bright, int red, int green, int blue) {
            this.bright = bright;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.foregroundSGR = String.format("%d%d", bright ? 9 : 3, index).getBytes();
            this.backgroundSGR = String.format("%d%d", bright ? 10 : 4, index).getBytes();
        }

        @Override
        public byte[] getForegroundSGRSequence() {
            return (byte[])this.foregroundSGR.clone();
        }

        @Override
        public byte[] getBackgroundSGRSequence() {
            return (byte[])this.backgroundSGR.clone();
        }

        public boolean isBright() {
            return this.bright;
        }

        @Override
        public int getRed() {
            return this.red;
        }

        @Override
        public int getGreen() {
            return this.green;
        }

        @Override
        public int getBlue() {
            return this.blue;
        }

        @Override
        public Color toColor() {
            return new Color(this.getRed(), this.getGreen(), this.getBlue());
        }
    }
}

