/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TextColor;
import java.util.Arrays;
import java.util.EnumSet;

public interface StyleSet<T extends StyleSet<T>> {
    public TextColor getBackgroundColor();

    public T setBackgroundColor(TextColor var1);

    public TextColor getForegroundColor();

    public T setForegroundColor(TextColor var1);

    public T enableModifiers(SGR ... var1);

    public T disableModifiers(SGR ... var1);

    public T setModifiers(EnumSet<SGR> var1);

    public T clearModifiers();

    public EnumSet<SGR> getActiveModifiers();

    public T setStyleFrom(StyleSet<?> var1);

    public static class Set
    implements StyleSet<Set> {
        private TextColor foregroundColor;
        private TextColor backgroundColor;
        private final EnumSet<SGR> style = EnumSet.noneOf(SGR.class);

        public Set() {
        }

        public Set(StyleSet<?> source) {
            this.setStyleFrom((StyleSet)source);
        }

        @Override
        public TextColor getBackgroundColor() {
            return this.backgroundColor;
        }

        @Override
        public Set setBackgroundColor(TextColor backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        public TextColor getForegroundColor() {
            return this.foregroundColor;
        }

        @Override
        public Set setForegroundColor(TextColor foregroundColor) {
            this.foregroundColor = foregroundColor;
            return this;
        }

        @Override
        public Set enableModifiers(SGR ... modifiers) {
            this.style.addAll(Arrays.asList(modifiers));
            return this;
        }

        @Override
        public Set disableModifiers(SGR ... modifiers) {
            this.style.removeAll(Arrays.asList(modifiers));
            return this;
        }

        @Override
        public Set setModifiers(EnumSet<SGR> modifiers) {
            this.style.clear();
            this.style.addAll(modifiers);
            return this;
        }

        @Override
        public Set clearModifiers() {
            this.style.clear();
            return this;
        }

        @Override
        public EnumSet<SGR> getActiveModifiers() {
            return EnumSet.copyOf(this.style);
        }

        @Override
        public Set setStyleFrom(StyleSet<?> source) {
            this.setBackgroundColor(source.getBackgroundColor());
            this.setForegroundColor(source.getForegroundColor());
            this.setModifiers((EnumSet)source.getActiveModifiers());
            return this;
        }
    }
}

