/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.Container;
import com.googlecode.lanterna.gui2.Label;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;

public class AnimatedLabel
extends Label {
    private static Timer TIMER = null;
    private static final WeakHashMap<AnimatedLabel, TimerTask> SCHEDULED_TASKS = new WeakHashMap();
    private final List<String[]> frames = new ArrayList<String[]>();
    private TerminalSize combinedMaximumPreferredSize = TerminalSize.ZERO;
    private int currentFrame = 0;

    public static AnimatedLabel createClassicSpinningLine() {
        return AnimatedLabel.createClassicSpinningLine(150);
    }

    public static AnimatedLabel createClassicSpinningLine(int speed) {
        AnimatedLabel animatedLabel = new AnimatedLabel("-");
        animatedLabel.addFrame("\\");
        animatedLabel.addFrame("|");
        animatedLabel.addFrame("/");
        animatedLabel.startAnimation(speed);
        return animatedLabel;
    }

    public AnimatedLabel(String firstFrameText) {
        super(firstFrameText);
        String[] lines = this.splitIntoMultipleLines(firstFrameText);
        this.frames.add(lines);
        this.ensurePreferredSize(lines);
    }

    @Override
    protected synchronized TerminalSize calculatePreferredSize() {
        return super.calculatePreferredSize().max(this.combinedMaximumPreferredSize);
    }

    public synchronized AnimatedLabel addFrame(String text) {
        String[] lines = this.splitIntoMultipleLines(text);
        this.frames.add(lines);
        this.ensurePreferredSize(lines);
        return this;
    }

    private void ensurePreferredSize(String[] lines) {
        this.combinedMaximumPreferredSize = this.combinedMaximumPreferredSize.max(this.getBounds(lines, this.combinedMaximumPreferredSize));
    }

    public synchronized void nextFrame() {
        ++this.currentFrame;
        if (this.currentFrame >= this.frames.size()) {
            this.currentFrame = 0;
        }
        super.setLines(this.frames.get(this.currentFrame));
        this.invalidate();
    }

    @Override
    public void onRemoved(Container container) {
        this.stopAnimation();
    }

    public synchronized AnimatedLabel startAnimation(long millisecondsPerFrame) {
        if (TIMER == null) {
            TIMER = new Timer("AnimatedLabel");
        }
        AnimationTimerTask animationTimerTask = new AnimationTimerTask(this);
        SCHEDULED_TASKS.put(this, animationTimerTask);
        TIMER.scheduleAtFixedRate((TimerTask)animationTimerTask, millisecondsPerFrame, millisecondsPerFrame);
        return this;
    }

    public synchronized AnimatedLabel stopAnimation() {
        AnimatedLabel.removeTaskFromTimer(this);
        return this;
    }

    private static synchronized void removeTaskFromTimer(AnimatedLabel animatedLabel) {
        SCHEDULED_TASKS.get(animatedLabel).cancel();
        SCHEDULED_TASKS.remove(animatedLabel);
        AnimatedLabel.canCloseTimer();
    }

    private static synchronized void canCloseTimer() {
        if (SCHEDULED_TASKS.isEmpty()) {
            TIMER.cancel();
            TIMER = null;
        }
    }

    private static class AnimationTimerTask
    extends TimerTask {
        private final WeakReference<AnimatedLabel> labelRef;

        private AnimationTimerTask(AnimatedLabel label) {
            this.labelRef = new WeakReference<AnimatedLabel>(label);
        }

        @Override
        public void run() {
            AnimatedLabel animatedLabel = (AnimatedLabel)this.labelRef.get();
            if (animatedLabel == null) {
                this.cancel();
                AnimatedLabel.canCloseTimer();
            } else if (animatedLabel.getBasePane() == null) {
                animatedLabel.stopAnimation();
            } else {
                animatedLabel.nextFrame();
            }
        }
    }
}

