/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbstractInteractableComponent;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableRenderer;
import com.googlecode.lanterna.gui2.ScrollBar;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.MouseAction;
import com.googlecode.lanterna.input.MouseActionType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class TextBox
extends AbstractInteractableComponent<TextBox> {
    private final List<String> lines = new ArrayList<String>();
    private final Style style;
    private TerminalPosition caretPosition;
    private boolean caretWarp;
    private boolean readOnly;
    private boolean horizontalFocusSwitching;
    private boolean verticalFocusSwitching;
    private final int maxLineLength;
    private int longestRow;
    private Character mask;
    private Pattern validationPattern;
    private TextChangeListener textChangeListener;

    public TextBox() {
        this(new TerminalSize(10, 1), "", Style.SINGLE_LINE);
    }

    public TextBox(String initialContent) {
        this(null, initialContent, initialContent.contains("\n") ? Style.MULTI_LINE : Style.SINGLE_LINE);
    }

    public TextBox(String initialContent, Style style) {
        this(null, initialContent, style);
    }

    public TextBox(TerminalSize preferredSize) {
        this(preferredSize, preferredSize != null && preferredSize.getRows() > 1 ? Style.MULTI_LINE : Style.SINGLE_LINE);
    }

    public TextBox(TerminalSize preferredSize, Style style) {
        this(preferredSize, "", style);
    }

    public TextBox(TerminalSize preferredSize, String initialContent) {
        this(preferredSize, initialContent, preferredSize != null && preferredSize.getRows() > 1 || initialContent.contains("\n") ? Style.MULTI_LINE : Style.SINGLE_LINE);
    }

    public TextBox(TerminalSize preferredSize, String initialContent, Style style) {
        this.style = style;
        this.readOnly = false;
        this.caretWarp = false;
        this.verticalFocusSwitching = true;
        this.horizontalFocusSwitching = style == Style.SINGLE_LINE;
        this.caretPosition = TerminalPosition.TOP_LEFT_CORNER;
        this.maxLineLength = -1;
        this.longestRow = 1;
        this.mask = null;
        this.validationPattern = null;
        this.textChangeListener = null;
        this.setText(initialContent);
        this.caretPosition = TerminalPosition.TOP_LEFT_CORNER.withColumn(this.getLine(0).length());
        if (preferredSize == null) {
            preferredSize = new TerminalSize(Math.max(10, this.longestRow), this.lines.size());
        }
        this.setPreferredSize(preferredSize);
    }

    public synchronized TextBox setValidationPattern(Pattern validationPattern) {
        if (validationPattern != null) {
            for (String line : this.lines) {
                if (this.validated(line)) continue;
                throw new IllegalStateException("TextBox validation pattern " + validationPattern + " does not match existing content");
            }
        }
        this.validationPattern = validationPattern;
        return this;
    }

    public synchronized TextBox setTextChangeListener(TextChangeListener textChangeListener) {
        this.textChangeListener = textChangeListener;
        return this;
    }

    public synchronized TextBox setText(String text) {
        String[] split = text.split("\n");
        if (split.length == 0) {
            split = new String[]{""};
        }
        this.lines.clear();
        this.longestRow = 1;
        for (String line : split) {
            this.addLine(line);
        }
        if (this.caretPosition.getRow() > this.lines.size() - 1) {
            this.caretPosition = this.caretPosition.withRow(this.lines.size() - 1);
        }
        if (this.caretPosition.getColumn() > this.lines.get(this.caretPosition.getRow()).length()) {
            this.caretPosition = this.caretPosition.withColumn(this.lines.get(this.caretPosition.getRow()).length());
        }
        this.invalidate();
        return this;
    }

    @Override
    public TextBoxRenderer getRenderer() {
        return (TextBoxRenderer)super.getRenderer();
    }

    public synchronized TextBox addLine(String line) {
        StringBuilder bob = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\n' && this.style == Style.MULTI_LINE) {
                String string = bob.toString();
                int lineWidth = TerminalTextUtils.getColumnWidth(string);
                this.lines.add(string);
                if (this.longestRow < lineWidth + 1) {
                    this.longestRow = lineWidth + 1;
                }
                this.addLine(line.substring(i + 1));
                return this;
            }
            if (Character.isISOControl(c)) continue;
            bob.append(c);
        }
        String string = bob.toString();
        if (!this.validated(string)) {
            throw new IllegalStateException("TextBox validation pattern " + this.validationPattern + " does not match the supplied text");
        }
        int lineWidth = TerminalTextUtils.getColumnWidth(string);
        this.lines.add(string);
        if (this.longestRow < lineWidth + 1) {
            this.longestRow = lineWidth + 1;
        }
        this.fireOnTextChanged(false);
        this.invalidate();
        return this;
    }

    public synchronized TextBox removeLine(int lineIndex) {
        if (this.style == Style.SINGLE_LINE) {
            if (lineIndex == 0) {
                this.setText("");
                return this;
            }
            throw new ArrayIndexOutOfBoundsException("Cannot remove line " + lineIndex + " from a single-line TextBox");
        }
        if (lineIndex < 0 || lineIndex >= this.lines.size()) {
            throw new ArrayIndexOutOfBoundsException("Invalid line index for TextBox with " + this.lines.size() + " lines: " + lineIndex);
        }
        this.lines.remove(lineIndex);
        if (this.caretPosition.getRow() == lineIndex) {
            this.setCaretPosition(this.caretPosition.getRow(), this.caretPosition.getColumn());
        } else if (this.caretPosition.getRow() > lineIndex) {
            this.setCaretPosition(this.caretPosition.getRow() - 1, this.caretPosition.getColumn());
        }
        this.fireOnTextChanged(false);
        return this;
    }

    public TextBox setCaretWarp(boolean caretWarp) {
        this.caretWarp = caretWarp;
        return this;
    }

    public boolean isCaretWarp() {
        return this.caretWarp;
    }

    public TerminalPosition getCaretPosition() {
        return this.caretPosition;
    }

    public synchronized TextBox setCaretPosition(int column) {
        return this.setCaretPosition(this.getCaretPosition().getRow(), column);
    }

    public synchronized TextBox setCaretPosition(int line, int column) {
        if (line < 0) {
            line = 0;
        } else if (line >= this.lines.size()) {
            line = this.lines.size() - 1;
        }
        if (column < 0) {
            column = 0;
        } else if (column > this.lines.get(line).length()) {
            column = this.lines.get(line).length();
        }
        this.caretPosition = this.caretPosition.withRow(line).withColumn(column);
        return this;
    }

    public synchronized String getText() {
        StringBuilder bob = new StringBuilder(this.lines.get(0));
        for (int i = 1; i < this.lines.size(); ++i) {
            bob.append("\n").append(this.lines.get(i));
        }
        return bob.toString();
    }

    public String getTextOrDefault(String defaultValueIfEmpty) {
        String text = this.getText();
        if (text.isEmpty()) {
            return defaultValueIfEmpty;
        }
        return text;
    }

    public Character getMask() {
        return this.mask;
    }

    public TextBox setMask(Character mask) {
        if (mask != null && TerminalTextUtils.isCharCJK(mask.charValue())) {
            throw new IllegalArgumentException("Cannot use a CJK character as a mask");
        }
        this.mask = mask;
        this.invalidate();
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public TextBox setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.invalidate();
        return this;
    }

    public boolean isVerticalFocusSwitching() {
        return this.verticalFocusSwitching;
    }

    public TextBox setVerticalFocusSwitching(boolean verticalFocusSwitching) {
        this.verticalFocusSwitching = verticalFocusSwitching;
        return this;
    }

    public boolean isHorizontalFocusSwitching() {
        return this.horizontalFocusSwitching;
    }

    public TextBox setHorizontalFocusSwitching(boolean horizontalFocusSwitching) {
        this.horizontalFocusSwitching = horizontalFocusSwitching;
        return this;
    }

    public synchronized String getLine(int index) {
        return this.lines.get(index);
    }

    public synchronized int getLineCount() {
        return this.lines.size();
    }

    @Override
    protected TextBoxRenderer createDefaultRenderer() {
        return new DefaultTextBoxRenderer();
    }

    @Override
    public synchronized Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        if (this.readOnly) {
            return this.handleKeyStrokeReadOnly(keyStroke);
        }
        String line = this.lines.get(this.caretPosition.getRow());
        boolean lineWasModified = false;
        Interactable.Result result = null;
        switch (keyStroke.getKeyType()) {
            case Character: {
                if ((this.maxLineLength == -1 || this.maxLineLength > line.length() + 1) && this.validated(line = line.substring(0, this.caretPosition.getColumn()) + keyStroke.getCharacter() + line.substring(this.caretPosition.getColumn()))) {
                    this.lines.set(this.caretPosition.getRow(), line);
                    lineWasModified = true;
                    this.caretPosition = this.caretPosition.withRelativeColumn(1);
                }
                result = Interactable.Result.HANDLED;
                break;
            }
            case Backspace: {
                String concatenatedLines;
                if (this.caretPosition.getColumn() > 0) {
                    if (this.validated(line = line.substring(0, this.caretPosition.getColumn() - 1) + line.substring(this.caretPosition.getColumn()))) {
                        this.lines.set(this.caretPosition.getRow(), line);
                        lineWasModified = true;
                        this.caretPosition = this.caretPosition.withRelativeColumn(-1);
                    }
                } else if (this.style == Style.MULTI_LINE && this.caretPosition.getRow() > 0 && this.validated(concatenatedLines = this.lines.get(this.caretPosition.getRow() - 1) + line)) {
                    this.lines.remove(this.caretPosition.getRow());
                    this.caretPosition = this.caretPosition.withRelativeRow(-1);
                    this.caretPosition = this.caretPosition.withColumn(this.lines.get(this.caretPosition.getRow()).length());
                    this.lines.set(this.caretPosition.getRow(), concatenatedLines);
                    lineWasModified = true;
                }
                result = Interactable.Result.HANDLED;
                break;
            }
            case Delete: {
                String concatenatedLines;
                if (this.caretPosition.getColumn() < line.length()) {
                    if (this.validated(line = line.substring(0, this.caretPosition.getColumn()) + line.substring(this.caretPosition.getColumn() + 1))) {
                        this.lines.set(this.caretPosition.getRow(), line);
                        lineWasModified = true;
                    }
                } else if (this.style == Style.MULTI_LINE && this.caretPosition.getRow() < this.lines.size() - 1 && this.validated(concatenatedLines = line + this.lines.get(this.caretPosition.getRow() + 1))) {
                    this.lines.set(this.caretPosition.getRow(), concatenatedLines);
                    this.lines.remove(this.caretPosition.getRow() + 1);
                    lineWasModified = true;
                }
                result = Interactable.Result.HANDLED;
                break;
            }
            case ArrowLeft: {
                if (this.caretPosition.getColumn() > 0) {
                    this.caretPosition = this.caretPosition.withRelativeColumn(-1);
                } else if (this.style == Style.MULTI_LINE && this.caretWarp && this.caretPosition.getRow() > 0) {
                    this.caretPosition = this.caretPosition.withRelativeRow(-1);
                    this.caretPosition = this.caretPosition.withColumn(this.lines.get(this.caretPosition.getRow()).length());
                } else if (this.horizontalFocusSwitching) {
                    result = Interactable.Result.MOVE_FOCUS_LEFT;
                }
                result = result == null ? Interactable.Result.HANDLED : result;
                break;
            }
            case ArrowRight: {
                if (this.caretPosition.getColumn() < this.lines.get(this.caretPosition.getRow()).length()) {
                    this.caretPosition = this.caretPosition.withRelativeColumn(1);
                } else if (this.style == Style.MULTI_LINE && this.caretWarp && this.caretPosition.getRow() < this.lines.size() - 1) {
                    this.caretPosition = this.caretPosition.withRelativeRow(1);
                    this.caretPosition = this.caretPosition.withColumn(0);
                } else if (this.horizontalFocusSwitching) {
                    result = Interactable.Result.MOVE_FOCUS_RIGHT;
                }
                result = result == null ? Interactable.Result.HANDLED : result;
                break;
            }
            case ArrowUp: {
                if (this.canMoveCaretUp()) {
                    this.performMoveCaretUp();
                } else if (this.verticalFocusSwitching) {
                    result = Interactable.Result.MOVE_FOCUS_UP;
                }
                result = result == null ? Interactable.Result.HANDLED : result;
                break;
            }
            case ArrowDown: {
                if (this.canMoveCaretDown()) {
                    this.performMoveCaretDown();
                } else if (this.verticalFocusSwitching) {
                    result = Interactable.Result.MOVE_FOCUS_DOWN;
                }
                result = result == null ? Interactable.Result.HANDLED : result;
                break;
            }
            case End: {
                this.caretPosition = this.caretPosition.withColumn(line.length());
                result = Interactable.Result.HANDLED;
                break;
            }
            case Enter: {
                if (this.style == Style.SINGLE_LINE) {
                    result = Interactable.Result.MOVE_FOCUS_NEXT;
                    break;
                }
                String newLine = line.substring(this.caretPosition.getColumn());
                String oldLine = line.substring(0, this.caretPosition.getColumn());
                if (this.validated(newLine) && this.validated(oldLine)) {
                    this.lines.set(this.caretPosition.getRow(), oldLine);
                    this.lines.add(this.caretPosition.getRow() + 1, newLine);
                    this.caretPosition = this.caretPosition.withColumn(0).withRelativeRow(1);
                    lineWasModified = true;
                }
                result = Interactable.Result.HANDLED;
                break;
            }
            case Home: {
                this.caretPosition = this.caretPosition.withColumn(0);
                result = Interactable.Result.HANDLED;
                break;
            }
            case PageDown: {
                this.caretPosition = this.caretPosition.withRelativeRow(this.getSize().getRows());
                if (this.caretPosition.getRow() > this.lines.size() - 1) {
                    this.caretPosition = this.caretPosition.withRow(this.lines.size() - 1);
                }
                if (this.lines.get(this.caretPosition.getRow()).length() < this.caretPosition.getColumn()) {
                    this.caretPosition = this.caretPosition.withColumn(this.lines.get(this.caretPosition.getRow()).length());
                }
                result = Interactable.Result.HANDLED;
                break;
            }
            case PageUp: {
                this.caretPosition = this.caretPosition.withRelativeRow(-this.getSize().getRows());
                if (this.caretPosition.getRow() < 0) {
                    this.caretPosition = this.caretPosition.withRow(0);
                }
                if (this.lines.get(this.caretPosition.getRow()).length() < this.caretPosition.getColumn()) {
                    this.caretPosition = this.caretPosition.withColumn(this.lines.get(this.caretPosition.getRow()).length());
                }
                result = Interactable.Result.HANDLED;
                break;
            }
            case MouseEvent: {
                if (!this.isFocused()) break;
                if (this.isMouseMove(keyStroke)) {
                    result = Interactable.Result.UNHANDLED;
                    break;
                }
                MouseAction mouseAction = (MouseAction)keyStroke;
                MouseActionType actionType = mouseAction.getActionType();
                if (actionType == MouseActionType.SCROLL_UP) {
                    if (this.canMoveCaretUp()) {
                        this.performMoveCaretUp();
                    }
                } else if (actionType == MouseActionType.SCROLL_DOWN) {
                    if (this.canMoveCaretDown()) {
                        this.performMoveCaretDown();
                    }
                } else {
                    TerminalPosition offset = this.getRenderer().getViewTopLeft();
                    int newCaretPositionColumn = mouseAction.getPosition().getColumn() - this.getGlobalPosition().getColumn() + offset.getColumn();
                    int newCaretPositionRow = mouseAction.getPosition().getRow() - this.getGlobalPosition().getRow() + offset.getRow();
                    if (newCaretPositionRow >= 0 && newCaretPositionRow < this.lines.size()) {
                        String newActiveLine = this.lines.get(newCaretPositionRow);
                        int minPositionAttempt = 0;
                        int maxPositionAttempt = newActiveLine.length();
                        newCaretPositionColumn = Math.max(minPositionAttempt, Math.min(newCaretPositionColumn, maxPositionAttempt));
                        this.caretPosition = this.caretPosition.with(new TerminalPosition(newCaretPositionColumn, newCaretPositionRow));
                    }
                }
                result = Interactable.Result.HANDLED;
            }
        }
        if (result == null) {
            result = super.handleKeyStroke(keyStroke);
        } else if (lineWasModified) {
            this.fireOnTextChanged(true);
        }
        return result;
    }

    private boolean canMoveCaretUp() {
        return this.caretPosition.getRow() > 0;
    }

    private boolean canMoveCaretDown() {
        return this.caretPosition.getRow() < this.lines.size() - 1;
    }

    private void performMoveCaretUp() {
        int trueColumnPosition = TerminalTextUtils.getColumnIndex(this.lines.get(this.caretPosition.getRow()), this.caretPosition.getColumn());
        this.caretPosition = this.caretPosition.withRelativeRow(-1);
        String line = this.lines.get(this.caretPosition.getRow());
        this.caretPosition = trueColumnPosition > TerminalTextUtils.getColumnWidth(line) ? this.caretPosition.withColumn(line.length()) : this.caretPosition.withColumn(TerminalTextUtils.getStringCharacterIndex(line, trueColumnPosition));
    }

    private void performMoveCaretDown() {
        int trueColumnPosition = TerminalTextUtils.getColumnIndex(this.lines.get(this.caretPosition.getRow()), this.caretPosition.getColumn());
        this.caretPosition = this.caretPosition.withRelativeRow(1);
        String line = this.lines.get(this.caretPosition.getRow());
        this.caretPosition = trueColumnPosition > TerminalTextUtils.getColumnWidth(line) ? this.caretPosition.withColumn(line.length()) : this.caretPosition.withColumn(TerminalTextUtils.getStringCharacterIndex(line, trueColumnPosition));
    }

    private boolean validated(String line) {
        return this.validationPattern == null || line.isEmpty() || this.validationPattern.matcher(line).matches();
    }

    private Interactable.Result handleKeyStrokeReadOnly(KeyStroke keyStroke) {
        switch (keyStroke.getKeyType()) {
            case ArrowLeft: {
                if (this.getRenderer().getViewTopLeft().getColumn() == 0 && this.horizontalFocusSwitching) {
                    return Interactable.Result.MOVE_FOCUS_LEFT;
                }
                this.getRenderer().setViewTopLeft(this.getRenderer().getViewTopLeft().withRelativeColumn(-1));
                return Interactable.Result.HANDLED;
            }
            case ArrowRight: {
                if (this.getRenderer().getViewTopLeft().getColumn() + this.getSize().getColumns() == this.longestRow && this.horizontalFocusSwitching) {
                    return Interactable.Result.MOVE_FOCUS_RIGHT;
                }
                this.getRenderer().setViewTopLeft(this.getRenderer().getViewTopLeft().withRelativeColumn(1));
                return Interactable.Result.HANDLED;
            }
            case ArrowUp: {
                if (this.getRenderer().getViewTopLeft().getRow() == 0 && this.verticalFocusSwitching) {
                    return Interactable.Result.MOVE_FOCUS_UP;
                }
                this.getRenderer().setViewTopLeft(this.getRenderer().getViewTopLeft().withRelativeRow(-1));
                return Interactable.Result.HANDLED;
            }
            case ArrowDown: {
                if (this.getRenderer().getViewTopLeft().getRow() + this.getSize().getRows() == this.lines.size() && this.verticalFocusSwitching) {
                    return Interactable.Result.MOVE_FOCUS_DOWN;
                }
                this.getRenderer().setViewTopLeft(this.getRenderer().getViewTopLeft().withRelativeRow(1));
                return Interactable.Result.HANDLED;
            }
            case Home: {
                this.getRenderer().setViewTopLeft(TerminalPosition.TOP_LEFT_CORNER);
                return Interactable.Result.HANDLED;
            }
            case End: {
                this.getRenderer().setViewTopLeft(TerminalPosition.TOP_LEFT_CORNER.withRow(this.getLineCount() - this.getSize().getRows()));
                return Interactable.Result.HANDLED;
            }
            case PageDown: {
                this.getRenderer().setViewTopLeft(this.getRenderer().getViewTopLeft().withRelativeRow(this.getSize().getRows()));
                return Interactable.Result.HANDLED;
            }
            case PageUp: {
                this.getRenderer().setViewTopLeft(this.getRenderer().getViewTopLeft().withRelativeRow(-this.getSize().getRows()));
                return Interactable.Result.HANDLED;
            }
        }
        return super.handleKeyStroke(keyStroke);
    }

    private void fireOnTextChanged(boolean initiatedByUserInteraction) {
        TextChangeListener textChangeListener = this.textChangeListener;
        if (textChangeListener != null) {
            String newText = this.getText();
            textChangeListener.onTextChanged(newText, initiatedByUserInteraction);
        }
    }

    public static interface TextChangeListener {
        public void onTextChanged(String var1, boolean var2);
    }

    public static class DefaultTextBoxRenderer
    implements TextBoxRenderer {
        private TerminalPosition viewTopLeft = TerminalPosition.TOP_LEFT_CORNER;
        private final ScrollBar verticalScrollBar = new ScrollBar(Direction.VERTICAL);
        private final ScrollBar horizontalScrollBar = new ScrollBar(Direction.HORIZONTAL);
        private boolean hideScrollBars = false;
        private Character unusedSpaceCharacter = null;

        public void setUnusedSpaceCharacter(char unusedSpaceCharacter) {
            if (TerminalTextUtils.isCharDoubleWidth(unusedSpaceCharacter)) {
                throw new IllegalArgumentException("Cannot use a double-width character as the unused space character in a TextBox");
            }
            this.unusedSpaceCharacter = Character.valueOf(unusedSpaceCharacter);
        }

        @Override
        public TerminalPosition getViewTopLeft() {
            return this.viewTopLeft;
        }

        @Override
        public void setViewTopLeft(TerminalPosition position) {
            if (position.getColumn() < 0) {
                position = position.withColumn(0);
            }
            if (position.getRow() < 0) {
                position = position.withRow(0);
            }
            this.viewTopLeft = position;
        }

        @Override
        public TerminalPosition getCursorLocation(TextBox component) {
            if (component.isReadOnly()) {
                return null;
            }
            TerminalPosition caretPosition = component.getCaretPosition();
            String line = component.getLine(caretPosition.getRow());
            caretPosition = caretPosition.withColumn(Math.min(caretPosition.getColumn(), line.length()));
            return caretPosition.withColumn(TerminalTextUtils.getColumnIndex(line, caretPosition.getColumn())).withRelativeColumn(-this.viewTopLeft.getColumn()).withRelativeRow(-this.viewTopLeft.getRow());
        }

        @Override
        public TerminalSize getPreferredSize(TextBox component) {
            return new TerminalSize(component.longestRow, component.lines.size());
        }

        public void setHideScrollBars(boolean hideScrollBars) {
            this.hideScrollBars = hideScrollBars;
        }

        @Override
        public void drawComponent(TextGUIGraphics graphics, TextBox component) {
            TerminalSize realTextArea = graphics.getSize();
            if (realTextArea.getRows() == 0 || realTextArea.getColumns() == 0) {
                return;
            }
            boolean drawVerticalScrollBar = false;
            boolean drawHorizontalScrollBar = false;
            int textBoxLineCount = component.getLineCount();
            if (!this.hideScrollBars && textBoxLineCount > realTextArea.getRows() && realTextArea.getColumns() > 1) {
                realTextArea = realTextArea.withRelativeColumns(-1);
                drawVerticalScrollBar = true;
            }
            if (!this.hideScrollBars && component.longestRow > realTextArea.getColumns() && realTextArea.getRows() > 1) {
                realTextArea = realTextArea.withRelativeRows(-1);
                drawHorizontalScrollBar = true;
                if (textBoxLineCount > realTextArea.getRows() && !drawVerticalScrollBar) {
                    realTextArea = realTextArea.withRelativeColumns(-1);
                    drawVerticalScrollBar = true;
                }
            }
            this.drawTextArea(graphics.newTextGraphics(TerminalPosition.TOP_LEFT_CORNER, realTextArea), component);
            if (drawVerticalScrollBar) {
                this.verticalScrollBar.onAdded(component.getParent());
                this.verticalScrollBar.setViewSize(realTextArea.getRows());
                this.verticalScrollBar.setScrollMaximum(textBoxLineCount);
                this.verticalScrollBar.setScrollPosition(this.viewTopLeft.getRow());
                this.verticalScrollBar.draw(graphics.newTextGraphics(new TerminalPosition(graphics.getSize().getColumns() - 1, 0), new TerminalSize(1, graphics.getSize().getRows() - (drawHorizontalScrollBar ? 1 : 0))));
            }
            if (drawHorizontalScrollBar) {
                this.horizontalScrollBar.onAdded(component.getParent());
                this.horizontalScrollBar.setViewSize(realTextArea.getColumns());
                this.horizontalScrollBar.setScrollMaximum(component.longestRow - 1);
                this.horizontalScrollBar.setScrollPosition(this.viewTopLeft.getColumn());
                this.horizontalScrollBar.draw(graphics.newTextGraphics(new TerminalPosition(0, graphics.getSize().getRows() - 1), new TerminalSize(graphics.getSize().getColumns() - (drawVerticalScrollBar ? 1 : 0), 1)));
            }
        }

        private void drawTextArea(TextGUIGraphics graphics, TextBox component) {
            TerminalSize textAreaSize = graphics.getSize();
            if (this.viewTopLeft.getColumn() + textAreaSize.getColumns() > component.longestRow) {
                this.viewTopLeft = this.viewTopLeft.withColumn(component.longestRow - textAreaSize.getColumns());
                if (this.viewTopLeft.getColumn() < 0) {
                    this.viewTopLeft = this.viewTopLeft.withColumn(0);
                }
            }
            if (this.viewTopLeft.getRow() + textAreaSize.getRows() > component.getLineCount()) {
                this.viewTopLeft = this.viewTopLeft.withRow(component.getLineCount() - textAreaSize.getRows());
                if (this.viewTopLeft.getRow() < 0) {
                    this.viewTopLeft = this.viewTopLeft.withRow(0);
                }
            }
            ThemeDefinition themeDefinition = component.getThemeDefinition();
            if (component.isFocused()) {
                if (component.isReadOnly()) {
                    graphics.applyThemeStyle(themeDefinition.getSelected());
                } else {
                    graphics.applyThemeStyle(themeDefinition.getActive());
                }
            } else if (component.isReadOnly()) {
                graphics.applyThemeStyle(themeDefinition.getInsensitive());
            } else {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            Character fillCharacter = this.unusedSpaceCharacter;
            if (fillCharacter == null) {
                fillCharacter = Character.valueOf(themeDefinition.getCharacter("FILL", ' '));
            }
            graphics.fill(fillCharacter.charValue());
            if (!component.isReadOnly()) {
                TerminalPosition caretPosition = component.getCaretPosition();
                String caretLine = component.getLine(caretPosition.getRow());
                int trueColumnPosition = TerminalTextUtils.getColumnIndex(caretLine, (caretPosition = caretPosition.withColumn(Math.min(caretPosition.getColumn(), caretLine.length()))).getColumn());
                if (trueColumnPosition < this.viewTopLeft.getColumn()) {
                    this.viewTopLeft = this.viewTopLeft.withColumn(trueColumnPosition);
                } else if (trueColumnPosition >= textAreaSize.getColumns() + this.viewTopLeft.getColumn()) {
                    this.viewTopLeft = this.viewTopLeft.withColumn(trueColumnPosition - textAreaSize.getColumns() + 1);
                }
                if (caretPosition.getRow() < this.viewTopLeft.getRow()) {
                    this.viewTopLeft = this.viewTopLeft.withRow(caretPosition.getRow());
                } else if (caretPosition.getRow() >= textAreaSize.getRows() + this.viewTopLeft.getRow()) {
                    this.viewTopLeft = this.viewTopLeft.withRow(caretPosition.getRow() - textAreaSize.getRows() + 1);
                }
                if (trueColumnPosition - this.viewTopLeft.getColumn() == graphics.getSize().getColumns() - 1 && caretLine.length() > caretPosition.getColumn() && TerminalTextUtils.isCharCJK(caretLine.charAt(caretPosition.getColumn()))) {
                    this.viewTopLeft = this.viewTopLeft.withRelativeColumn(1);
                }
            }
            for (int row = 0; row < textAreaSize.getRows(); ++row) {
                int rowIndex = row + this.viewTopLeft.getRow();
                if (rowIndex >= component.lines.size()) continue;
                String line = (String)component.lines.get(rowIndex);
                if (component.getMask() != null) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < line.length(); ++i) {
                        builder.append(component.getMask());
                    }
                    line = builder.toString();
                }
                graphics.putString(0, row, TerminalTextUtils.fitString(line, this.viewTopLeft.getColumn(), textAreaSize.getColumns()));
            }
        }
    }

    public static interface TextBoxRenderer
    extends InteractableRenderer<TextBox> {
        public TerminalPosition getViewTopLeft();

        public void setViewTopLeft(TerminalPosition var1);
    }

    public static enum Style {
        SINGLE_LINE,
        MULTI_LINE;

    }
}

