/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.gui2.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class WindowList {
    private final List<Window> windows = new LinkedList<Window>();
    private final List<Window> stableOrderingOfWindows = new ArrayList<Window>();
    private Window activeWindow = null;
    private boolean hadWindowAtSomePoint = false;

    public List<Window> getWindowsInZOrder() {
        return Collections.unmodifiableList(this.windows);
    }

    public List<Window> getWindowsInStableOrder() {
        return Collections.unmodifiableList(this.stableOrderingOfWindows);
    }

    public void setActiveWindow(Window activeWindow) {
        this.activeWindow = activeWindow;
        if (activeWindow != null) {
            this.moveToTop(activeWindow);
        }
    }

    public Window getActiveWindow() {
        return this.activeWindow;
    }

    public void addWindow(Window window) {
        if (!this.stableOrderingOfWindows.contains(window)) {
            this.stableOrderingOfWindows.add(window);
        }
        if (!this.windows.contains(window)) {
            this.windows.add(window);
        }
        if (!window.getHints().contains(Window.Hint.NO_FOCUS)) {
            this.setActiveWindow(window);
        }
        this.hadWindowAtSomePoint = true;
    }

    public boolean removeWindow(Window window) {
        boolean contained = this.windows.remove(window);
        this.stableOrderingOfWindows.remove(window);
        if (this.activeWindow == window) {
            this.setActiveWindow(null);
            for (int index = this.windows.size() - 1; index >= 0; --index) {
                Window candidate = this.windows.get(index);
                if (candidate.getHints().contains(Window.Hint.NO_FOCUS)) continue;
                this.setActiveWindow(candidate);
                break;
            }
        }
        return contained;
    }

    public boolean isHadWindowAtSomePoint() {
        return this.hadWindowAtSomePoint;
    }

    public void moveToTop(Window window) {
        if (!this.windows.contains(window)) {
            throw new IllegalArgumentException("Window " + window + " isn't in MultiWindowTextGUI " + this);
        }
        this.windows.remove(window);
        this.windows.add(window);
    }

    public void moveToBottom(Window window) {
        if (!this.windows.contains(window)) {
            throw new IllegalArgumentException("Window " + window + " isn't in MultiWindowTextGUI " + this);
        }
        this.windows.remove(window);
        this.windows.add(0, window);
    }

    public void cycleActiveWindow(boolean reverse) {
        if (this.windows.isEmpty() || this.windows.size() == 1 || this.activeWindow != null && this.activeWindow.getHints().contains(Window.Hint.MODAL)) {
            return;
        }
        Window originalActiveWindow = this.activeWindow;
        Window nextWindow = this.activeWindow == null ? (reverse ? this.windows.get(this.windows.size() - 1) : this.windows.get(0)) : this.getNextWindow(reverse, this.activeWindow);
        int noFocusWindows = 0;
        while (nextWindow.getHints().contains(Window.Hint.NO_FOCUS)) {
            if (++noFocusWindows == this.windows.size()) {
                return;
            }
            if ((nextWindow = this.getNextWindow(reverse, nextWindow)) != originalActiveWindow) continue;
            return;
        }
        if (reverse) {
            this.moveToTop(nextWindow);
        } else if (originalActiveWindow != null) {
            this.moveToBottom(originalActiveWindow);
        }
        this.setActiveWindow(nextWindow);
    }

    private Window getNextWindow(boolean reverse, Window window) {
        int index = this.windows.indexOf(window);
        if (reverse) {
            if (++index >= this.windows.size()) {
                index = 0;
            }
        } else if (--index < 0) {
            index = this.windows.size() - 1;
        }
        return this.windows.get(index);
    }
}

