/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.dialogs;

import com.googlecode.lanterna.gui2.AbstractWindow;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractDialogBuilder<B, T extends DialogWindow> {
    protected String title;
    protected String description;
    protected Set<Window.Hint> extraWindowHints;

    public AbstractDialogBuilder(String title) {
        this.title = title;
        this.description = null;
        this.extraWindowHints = Collections.singleton(Window.Hint.CENTERED);
    }

    public B setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.title = title;
        return this.self();
    }

    public String getTitle() {
        return this.title;
    }

    public B setDescription(String description) {
        this.description = description;
        return this.self();
    }

    public String getDescription() {
        return this.description;
    }

    public B setExtraWindowHints(Set<Window.Hint> extraWindowHints) {
        this.extraWindowHints = extraWindowHints;
        return this.self();
    }

    public Set<Window.Hint> getExtraWindowHints() {
        return this.extraWindowHints;
    }

    protected abstract B self();

    protected abstract T buildDialog();

    public final T build() {
        T dialog = this.buildDialog();
        if (!this.extraWindowHints.isEmpty()) {
            HashSet<Window.Hint> combinedHints = new HashSet<Window.Hint>(((AbstractWindow)dialog).getHints());
            combinedHints.addAll(this.extraWindowHints);
            ((AbstractWindow)dialog).setHints(combinedHints);
        }
        return dialog;
    }
}

