/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.backup;

import de.toxicfox.backup.core.SessionResult;
import de.toxicfox.config.ConfigFile;
import de.toxicfox.config.auto.Saved;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.util.Properties;

public class SMTP
extends ConfigFile {
    @Saved
    private String serverHostname = "mail.toxicfox.de";
    @Saved
    private int serverPort = 465;
    @Saved
    private String sourceMailAddress = "server@glowman554.de";
    @Saved
    private String password = "";
    private String recipient;

    public SMTP(String recipient) {
        super(new File("smtp.json"));
        this.setSaveAfterLoad(true);
        this.recipient = recipient;
    }

    @Override
    public void load() {
        super.load();
    }

    private Session start() {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.serverHostname);
        props.put("mail.smtp.socketFactory.port", String.valueOf(this.serverPort));
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.port", String.valueOf(this.serverPort));
        Session session = Session.getInstance(props, new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SMTP.this.sourceMailAddress, SMTP.this.password);
            }
        });
        session.setDebug(true);
        return session;
    }

    public void notifySuccess(SessionResult result) {
        try {
            Session session = this.start();
            MimeMessage message = new MimeMessage(session);
            ((Message)message).setFrom(new InternetAddress(this.sourceMailAddress));
            ((Message)message).setRecipients(Message.RecipientType.TO, InternetAddress.parse(this.recipient));
            ((Message)message).setSubject("Backup job succeeded");
            Object msg = "The backup job succeeded.\n";
            msg = (String)msg + String.format("Session ID: %d\n", result.getTimestamp());
            msg = (String)msg + String.format("Changed files: %d (%s)\n", result.getChangedFiles(), result.getChangedFilesSizeGB());
            msg = (String)msg + String.format("Deleted files: %d\n", result.getDeletions());
            if (result.getFailedFiles().size() > 0) {
                msg = (String)msg + "\nFailed files:\n";
                for (String file : result.getFailedFiles()) {
                    msg = (String)msg + file + "\n";
                }
            }
            message.setText((String)msg);
            Transport.send(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notifyError(Exception result) {
        try {
            Session session = this.start();
            MimeMessage message = new MimeMessage(session);
            ((Message)message).setFrom(new InternetAddress(this.sourceMailAddress));
            ((Message)message).setRecipients(Message.RecipientType.TO, InternetAddress.parse(this.recipient));
            ((Message)message).setSubject("Backup job failed");
            Object msg = "The backup job encountered an error.\n\n";
            msg = (String)msg + String.format("Exception: %s%n", result.getClass().getName());
            msg = (String)msg + String.format("Message: %s%n%n", result.getMessage());
            msg = (String)msg + "Stacktrace:\n";
            for (StackTraceElement element : result.getStackTrace()) {
                msg = (String)msg + String.format("  at %s%n", element.toString());
            }
            message.setText((String)msg);
            Transport.send(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

