/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.backup.cli;

import de.toxicfox.backup.core.IUserInterface;
import java.io.File;
import java.util.Scanner;

public class CliUserInterface
implements IUserInterface {
    private IUserInterface.State previousState = null;

    @Override
    public void log(String message) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        System.out.printf("[%s::%s at %s:%s] %s\n", stackTraceElements[2].getClassName(), stackTraceElements[2].getMethodName(), stackTraceElements[2].getFileName(), stackTraceElements[2].getLineNumber(), message);
    }

    @Override
    public void setProgress(int progress) {
        this.log(progress + "%");
    }

    @Override
    public void setState(IUserInterface.State state) {
        if (this.previousState != state) {
            this.log("State: " + String.valueOf((Object)state));
            this.previousState = state;
        }
    }

    @Override
    public void error(Exception e) {
        throw new RuntimeException(e);
    }

    @Override
    public File pickSessionToRestore() {
        try (Scanner scanner = new Scanner(System.in);){
            System.out.println("Enter the path of the session file to restore: ");
            File file = new File(scanner.nextLine());
            return file;
        }
    }
}

