/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.backup.core.util;

import de.toxicfox.backup.core.IUserInterface;
import de.toxicfox.backup.core.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class FileModificationEncryption
implements FileUtil.FileModification {
    private final SecretKeySpec secretKey;
    private final SecureRandom random = new SecureRandom();

    public FileModificationEncryption(File keyFile, IUserInterface userInterface) throws Exception {
        if (keyFile.exists()) {
            byte[] keyBytes = Files.readAllBytes(keyFile.toPath());
            this.secretKey = new SecretKeySpec(keyBytes, "AES");
        } else {
            userInterface.log("Created encryption key at " + keyFile.getAbsolutePath());
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            SecretKey key = keyGen.generateKey();
            try (FileOutputStream fos = new FileOutputStream(keyFile);){
                fos.write(key.getEncoded());
            }
            this.secretKey = new SecretKeySpec(key.getEncoded(), "AES");
        }
    }

    @Override
    public OutputStream apply(OutputStream stream) throws IOException {
        try {
            byte[] iv = new byte[16];
            this.random.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            stream.write(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)this.secretKey, ivSpec);
            return new CipherOutputStream(stream, cipher);
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize AES encryption", e);
        }
    }

    @Override
    public InputStream unapply(InputStream stream) throws IOException {
        try {
            byte[] iv = new byte[16];
            if (stream.read(iv) != 16) {
                throw new IOException("Invalid encrypted file: missing IV");
            }
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)this.secretKey, ivSpec);
            return new CipherInputStream(stream, cipher);
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize AES decryption", e);
        }
    }
}

