/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.backup.tui;

import com.googlecode.lanterna.gui2.MultiWindowTextGUI;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.FileDialog;
import com.googlecode.lanterna.gui2.dialogs.FileDialogBuilder;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogBuilder;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import com.googlecode.lanterna.screen.TerminalScreen;
import com.googlecode.lanterna.terminal.DefaultTerminalFactory;
import com.googlecode.lanterna.terminal.Terminal;
import de.toxicfox.backup.core.IUserInterface;
import de.toxicfox.backup.tui.AbstractState;
import de.toxicfox.backup.tui.DebugWindow;
import de.toxicfox.backup.tui.ProgressingState;
import de.toxicfox.backup.tui.StateInstance;
import java.io.File;
import java.io.IOException;

public class TuiUserInterface
implements IUserInterface {
    private final Terminal terminal;
    private final WindowBasedTextGUI textGUI;
    private final DebugWindow debugWindow;
    private StateInstance current = StateInstance.DEFAULT;

    public TuiUserInterface() throws IOException {
        this.terminal = new DefaultTerminalFactory().createTerminal();
        TerminalScreen screen = new TerminalScreen(this.terminal);
        screen.startScreen();
        this.textGUI = new MultiWindowTextGUI(screen);
        this.debugWindow = new DebugWindow();
        this.textGUI.addWindow(this.debugWindow);
    }

    @Override
    public File pickSessionToRestore() {
        return ((FileDialog)((FileDialogBuilder)((FileDialogBuilder)new FileDialogBuilder().setTitle("Open File")).setDescription("Choose a session to restore")).setActionLabel("Restore").build()).showDialog(this.textGUI);
    }

    private void transferState(StateInstance newState) {
        if (newState != this.current) {
            this.current.getState().exit(this.textGUI);
            this.current = newState;
            this.current.getState().entry(this.textGUI);
        }
    }

    @Override
    public void log(String message) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String debugMessage = String.format("[%s::%s at %s:%s] %s", stackTraceElements[2].getClassName(), stackTraceElements[2].getMethodName(), stackTraceElements[2].getFileName(), stackTraceElements[2].getLineNumber(), message);
        this.debugWindow.log(debugMessage);
        this.safeUpdate();
    }

    @Override
    public void setProgress(int progress) {
        AbstractState abstractState = this.current.getState();
        if (abstractState instanceof ProgressingState) {
            ProgressingState progressingState = (ProgressingState)abstractState;
            progressingState.setProgress(progress);
        }
        this.safeUpdate();
    }

    @Override
    public void setState(IUserInterface.State state) {
        try {
            switch (state) {
                case INDEXING: {
                    this.transferState(StateInstance.INDEXING);
                    break;
                }
                case DIFFING: {
                    this.transferState(StateInstance.DEFAULT);
                    break;
                }
                case COPYING: {
                    this.transferState(StateInstance.COPYING);
                    break;
                }
                case DONE_BACKUP: {
                    new MessageDialogBuilder().setTitle("Done").setText("Backup completed successfully.").addButton(MessageDialogButton.Close).build().showDialog(this.textGUI);
                    this.terminal.close();
                    return;
                }
                case DONE_RESTORE: {
                    new MessageDialogBuilder().setTitle("Done").setText("Restore completed successfully.").addButton(MessageDialogButton.Close).build().showDialog(this.textGUI);
                    this.terminal.close();
                    return;
                }
            }
            this.safeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void error(Exception e) {
        StringBuilder fullStackTrace = new StringBuilder();
        fullStackTrace.append(e.getClass().getName()).append(": ").append(e.getMessage()).append("\n");
        for (StackTraceElement element : e.getStackTrace()) {
            fullStackTrace.append(element.toString()).append("\n");
        }
        new MessageDialogBuilder().setTitle("Error").setText(fullStackTrace.toString()).addButton(MessageDialogButton.Close).build().showDialog(this.textGUI);
    }

    private void safeUpdate() {
        this.current.getState().update(this.textGUI);
        try {
            this.textGUI.updateScreen();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

