/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.backup.tui.states;

import com.googlecode.lanterna.gui2.BasicWindow;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import de.toxicfox.backup.tui.AbstractState;
import java.util.List;

public class IndexingWindow
extends AbstractState {
    private final BasicWindow window = new BasicWindow("Indexing");
    private final Label label = new Label("Indexing files...");
    private long begin;

    public IndexingWindow() {
        Panel panel = new Panel();
        panel.addComponent(this.label);
        this.window.setComponent(panel);
        this.window.setHints(List.of(Window.Hint.CENTERED));
    }

    @Override
    public void entry(WindowBasedTextGUI gui) {
        this.begin = System.currentTimeMillis();
        gui.addWindow(this.window);
    }

    @Override
    public void update(WindowBasedTextGUI gui) {
        long elapsed = System.currentTimeMillis() - this.begin;
        this.label.setText("Indexing files... (" + (elapsed /= 1000L) + "s)");
    }

    @Override
    public void exit(WindowBasedTextGUI gui) {
        gui.removeWindow(this.window);
    }
}

