/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.io.Reader;
import net.shadew.json.AbstractLexer;
import net.shadew.json.CharUtil;
import net.shadew.json.JsonSyntaxException;
import net.shadew.json.Token;
import net.shadew.json.TokenType;
import net.shadew.json.UnparsedNumber;

class JsonLexer
extends AbstractLexer {
    JsonLexer(Reader reader) {
        super(reader);
    }

    @Override
    protected AbstractLexer.LexerState defaultState() {
        return JsonLexerState.DEFAULT;
    }

    private static enum JsonLexerState implements AbstractLexer.LexerState
    {
        DEFAULT{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                if (CharUtil.isEof(c)) {
                    lex.startToken();
                    return lex.newToken(TokenType.EOF, null);
                }
                if (CharUtil.isWhitespace(c)) {
                    return null;
                }
                if (c == 123) {
                    lex.startToken();
                    return lex.newToken(TokenType.OBJECT_START, null);
                }
                if (c == 125) {
                    lex.startToken();
                    return lex.newToken(TokenType.OBJECT_END, null);
                }
                if (c == 91) {
                    lex.startToken();
                    return lex.newToken(TokenType.ARRAY_START, null);
                }
                if (c == 93) {
                    lex.startToken();
                    return lex.newToken(TokenType.ARRAY_END, null);
                }
                if (c == 58) {
                    lex.startToken();
                    return lex.newToken(TokenType.COLON, null);
                }
                if (c == 44) {
                    lex.startToken();
                    return lex.newToken(TokenType.COMMA, null);
                }
                if (c == 34) {
                    lex.clear();
                    lex.state(STRING);
                    lex.startToken();
                    return null;
                }
                if (CharUtil.isDigit(c)) {
                    lex.clear();
                    lex.retain();
                    lex.state(NUMBER_START);
                    lex.startToken();
                    return null;
                }
                if (c == 45) {
                    lex.clear();
                    lex.store(45);
                    lex.state(NUMBER_SIGN);
                    lex.startToken();
                    return null;
                }
                if (CharUtil.isIdentifierStart(c)) {
                    lex.clear();
                    lex.store(c);
                    lex.state(KEYWORD);
                    lex.startToken();
                    return null;
                }
                lex.startToken();
                throw lex.localError("Illegal character");
            }
        }
        ,
        STRING{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                if (CharUtil.isNewline(c) || CharUtil.isEof(c)) {
                    throw lex.localError("Expected string end");
                }
                if (c == 92) {
                    lex.state(STRING_ESCAPE);
                } else {
                    if (c == 34) {
                        lex.state(DEFAULT);
                        return lex.newToken(TokenType.STRING, lex.buffered());
                    }
                    lex.store(c);
                }
                return null;
            }
        }
        ,
        STRING_ESCAPE{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                if (CharUtil.isNewline(c) || CharUtil.isEof(c)) {
                    throw lex.localError("Expected string escape");
                }
                if (c == 92) {
                    lex.store(92);
                } else if (c == 34) {
                    lex.store(34);
                } else if (c == 47) {
                    lex.store(47);
                } else if (c == 110) {
                    lex.store(10);
                } else if (c == 98) {
                    lex.store(8);
                } else if (c == 114) {
                    lex.store(13);
                } else if (c == 102) {
                    lex.store(12);
                } else if (c == 116) {
                    lex.store(9);
                } else {
                    if (c == 117) {
                        lex.store(0);
                        lex.state(UNICODE_ESCAPE_1);
                        return null;
                    }
                    throw lex.localError("Illegal string escape");
                }
                lex.state(STRING);
                return null;
            }
        }
        ,
        UNICODE_ESCAPE_1{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw lex.localError("Expected 4 more hex digits");
                }
                int s = lex.unstore();
                lex.store(s |= hex << 12);
                lex.state(UNICODE_ESCAPE_2);
                return null;
            }
        }
        ,
        UNICODE_ESCAPE_2{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw lex.localError("Expected 3 more hex digits");
                }
                int s = lex.unstore();
                lex.store(s |= hex << 8);
                lex.state(UNICODE_ESCAPE_3);
                return null;
            }
        }
        ,
        UNICODE_ESCAPE_3{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw lex.localError("Expected 2 more hex digits");
                }
                int s = lex.unstore();
                lex.store(s |= hex << 4);
                lex.state(UNICODE_ESCAPE_4);
                return null;
            }
        }
        ,
        UNICODE_ESCAPE_4{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw lex.localError("Expected 1 more hex digit");
                }
                int s = lex.unstore();
                lex.store(s |= hex);
                lex.state(STRING);
                return null;
            }
        }
        ,
        KEYWORD{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                String kw;
                if (CharUtil.isIdentifier(c)) {
                    lex.store(c);
                    return null;
                }
                lex.state(DEFAULT);
                lex.retain();
                switch (kw = lex.buffered()) {
                    case "false": {
                        return lex.newToken(TokenType.BOOLEAN, false);
                    }
                    case "true": {
                        return lex.newToken(TokenType.BOOLEAN, true);
                    }
                    case "null": {
                        return lex.newToken(TokenType.NULL, null);
                    }
                }
                throw lex.error("Illegal identifier");
            }
        }
        ,
        NUMBER_SIGN{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                if (CharUtil.isDigit(c)) {
                    lex.state(NUMBER_START);
                    lex.retain();
                    return null;
                }
                throw lex.localError("Expected number");
            }
        }
        ,
        NUMBER_START{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                if (c == 48) {
                    lex.store(c);
                    lex.state(NUMBER_DECIMAL_START);
                } else if (CharUtil.isDigit1to9(c)) {
                    lex.store(c);
                    lex.state(NUMBER_INTEGER);
                } else {
                    throw lex.localError("Expected number");
                }
                return null;
            }
        }
        ,
        NUMBER_INTEGER{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isDigit(c)) {
                    lex.store(c);
                } else {
                    lex.retain();
                    lex.state(NUMBER_DECIMAL_START);
                }
                return null;
            }
        }
        ,
        NUMBER_DECIMAL_START{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                if (c == 46) {
                    lex.store(c);
                    lex.state(NUMBER_DECIMAL_FIRST);
                } else if (!CharUtil.isDigit(c)) {
                    lex.retain();
                    lex.state(NUMBER_EXPONENT_START);
                } else {
                    throw lex.error("Illegal digit");
                }
                return null;
            }
        }
        ,
        NUMBER_DECIMAL_FIRST{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                if (!CharUtil.isDigit(c)) {
                    throw lex.localError("Expected decimal digit");
                }
                lex.store(c);
                lex.state(NUMBER_DECIMAL);
                return null;
            }
        }
        ,
        NUMBER_DECIMAL{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isDigit(c)) {
                    lex.store(c);
                } else {
                    lex.retain();
                    lex.state(NUMBER_EXPONENT_START);
                }
                return null;
            }
        }
        ,
        NUMBER_EXPONENT_START{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                if (c == 101 || c == 69) {
                    lex.store(c);
                    lex.state(NUMBER_EXPONENT_SIGN);
                } else if (!CharUtil.isDigit(c)) {
                    lex.retain();
                    lex.state(NUMBER_END);
                } else {
                    throw lex.error("Illegal digit");
                }
                return null;
            }
        }
        ,
        NUMBER_EXPONENT_SIGN{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (c == 45 || c == 43) {
                    lex.store(c);
                } else {
                    lex.retain();
                }
                lex.state(NUMBER_EXPONENT_FIRST);
                return null;
            }
        }
        ,
        NUMBER_EXPONENT_FIRST{

            @Override
            public Token lex(int c, AbstractLexer lex) throws JsonSyntaxException {
                if (!CharUtil.isDigit(c)) {
                    throw lex.localError("Expected exponent digit");
                }
                lex.store(c);
                lex.state(NUMBER_EXPONENT);
                return null;
            }
        }
        ,
        NUMBER_EXPONENT{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isDigit(c)) {
                    lex.store(c);
                } else {
                    lex.retain();
                    lex.state(NUMBER_END);
                }
                return null;
            }
        }
        ,
        NUMBER_END{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                lex.retain();
                String nr = lex.buffered();
                return lex.newToken(TokenType.NUMBER, new UnparsedNumber(nr));
            }
        };

    }
}

