/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.shadew.json.AbstractJsonNode;
import net.shadew.json.ArrayNode;
import net.shadew.json.BooleanNode;
import net.shadew.json.JsonArrayCollector;
import net.shadew.json.JsonPath;
import net.shadew.json.JsonType;
import net.shadew.json.NullNode;
import net.shadew.json.NumberNode;
import net.shadew.json.ObjectNode;
import net.shadew.json.StringNode;
import net.shadew.json.UnparsedNumber;
import net.shadew.json.codec.JsonRepresentable;

public interface JsonNode
extends Iterable<JsonNode>,
JsonRepresentable {
    public static final JsonNode NULL = new NullNode();
    public static final JsonNode TRUE = new BooleanNode(true);
    public static final JsonNode FALSE = new BooleanNode(false);
    public static final JsonNode EMPTY_STRING = new StringNode("");
    public static final JsonNode ZERO = new NumberNode(0);

    public static JsonNode orNull(JsonNode node) {
        if (node == null) {
            return NULL;
        }
        if (!(node instanceof AbstractJsonNode)) {
            throw new IllegalArgumentException("JsonNode implementation is not a builtin implementation. This breaks");
        }
        return node;
    }

    public static JsonNode bool(Boolean value) {
        if (value == null) {
            return NULL;
        }
        return value != false ? TRUE : FALSE;
    }

    public static JsonNode string(String value) {
        if (value == null) {
            return NULL;
        }
        return value.isEmpty() ? EMPTY_STRING : new StringNode(value);
    }

    public static JsonNode number(Number value) {
        if (value == null) {
            return NULL;
        }
        return UnparsedNumber.isZero(value) ? ZERO : new NumberNode(value);
    }

    public static JsonNode array() {
        return new ArrayNode();
    }

    public static JsonNode array(JsonNode ... elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        return new ArrayNode(elems);
    }

    public static JsonNode array(Iterable<? extends JsonNode> elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        return new ArrayNode(elems);
    }

    public static JsonNode stringArray(String ... elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (String elem : elems) {
            node.add(elem);
        }
        return node;
    }

    public static JsonNode numberArray(Number ... elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (Number elem : elems) {
            node.add(elem);
        }
        return node;
    }

    public static JsonNode numberArray(byte ... elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (byte elem : elems) {
            node.add(elem);
        }
        return node;
    }

    public static JsonNode numberArray(short ... elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (short elem : elems) {
            node.add(elem);
        }
        return node;
    }

    public static JsonNode numberArray(int ... elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (int elem : elems) {
            node.add(elem);
        }
        return node;
    }

    public static JsonNode numberArray(long ... elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (long elem : elems) {
            node.add(elem);
        }
        return node;
    }

    public static JsonNode numberArray(float ... elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (float elem : elems) {
            node.add(Float.valueOf(elem));
        }
        return node;
    }

    public static JsonNode numberArray(double ... elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (double elem : elems) {
            node.add(elem);
        }
        return node;
    }

    public static JsonNode boolArray(Boolean ... elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (Boolean elem : elems) {
            node.add(elem);
        }
        return node;
    }

    public static JsonNode boolArray(boolean[] elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (boolean elem : elems) {
            node.add(elem);
        }
        return node;
    }

    public static JsonNode stringArray(Iterable<? extends String> elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (String string : elems) {
            node.add(string);
        }
        return node;
    }

    public static JsonNode numberArray(Iterable<? extends Number> elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (Number number : elems) {
            node.add(number);
        }
        return node;
    }

    public static JsonNode boolArray(Iterable<Boolean> elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ArrayNode node = new ArrayNode();
        for (Boolean elem : elems) {
            node.add(elem);
        }
        return node;
    }

    public static JsonNode nullArray(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative size");
        }
        return new ArrayNode(size);
    }

    public static JsonNode object() {
        return new ObjectNode();
    }

    public static JsonNode object(Map<? extends String, ? extends JsonNode> elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        return new ObjectNode(elems);
    }

    public static JsonNode stringObject(Map<? extends String, ? extends String> elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ObjectNode node = new ObjectNode();
        elems.forEach(node::set);
        return node;
    }

    public static JsonNode numberObject(Map<? extends String, ? extends Number> elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ObjectNode node = new ObjectNode();
        elems.forEach(node::set);
        return node;
    }

    public static JsonNode boolObject(Map<? extends String, ? extends Boolean> elems) {
        if (elems == null) {
            throw new NullPointerException();
        }
        ObjectNode node = new ObjectNode();
        elems.forEach(node::set);
        return node;
    }

    @Deprecated
    public static JsonNode fromJavaObject(Object obj) {
        if (obj == null) {
            return NULL;
        }
        if (obj instanceof JsonNode) {
            return (JsonNode)obj;
        }
        if (obj instanceof JsonRepresentable) {
            return JsonNode.orNull(((JsonRepresentable)obj).toJson());
        }
        if (obj instanceof Boolean) {
            return JsonNode.bool((Boolean)obj);
        }
        if (obj instanceof Number) {
            return JsonNode.number((Number)obj);
        }
        if (obj instanceof String) {
            return JsonNode.string((String)obj);
        }
        if (obj instanceof File) {
            return JsonNode.string(obj.toString());
        }
        if (obj instanceof Path) {
            return JsonNode.string(obj.toString());
        }
        if (obj instanceof URL) {
            return JsonNode.string(obj.toString());
        }
        if (obj instanceof URI) {
            return JsonNode.string(obj.toString());
        }
        if (obj instanceof JsonPath) {
            return JsonNode.string(obj.toString());
        }
        if (obj instanceof Enum) {
            return JsonNode.string(((Enum)obj).name());
        }
        if (obj instanceof Stream) {
            Stream itr = (Stream)obj;
            ArrayNode node = new ArrayNode();
            itr.map(JsonNode::fromJavaObject).forEach(node::add);
            return node;
        }
        if (obj instanceof Iterable) {
            Iterable itr = (Iterable)obj;
            ArrayNode node = new ArrayNode();
            for (Object el : itr) {
                node.add(JsonNode.fromJavaObject(el));
            }
            return node;
        }
        if (obj instanceof Iterator) {
            Iterator itr = (Iterator)obj;
            ArrayNode node = new ArrayNode();
            while (itr.hasNext()) {
                node.add(JsonNode.fromJavaObject(itr.next()));
            }
            return node;
        }
        if (obj instanceof Enumeration) {
            Enumeration itr = (Enumeration)obj;
            ArrayNode node = new ArrayNode();
            while (itr.hasMoreElements()) {
                node.add(JsonNode.fromJavaObject(itr.nextElement()));
            }
            return node;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            ObjectNode node = new ObjectNode();
            map.forEach((? super K k, ? super V v) -> node.set(String.valueOf(k), JsonNode.fromJavaObject(v)));
            return node;
        }
        if (obj instanceof Dictionary) {
            Dictionary map = (Dictionary)obj;
            ObjectNode node = new ObjectNode();
            Enumeration keys = map.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                node.set(String.valueOf(key), JsonNode.fromJavaObject(map.get(key)));
            }
            return node;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            ArrayNode node = new ArrayNode();
            for (int i = 0; i < len; ++i) {
                node.add(JsonNode.fromJavaObject(Array.get(obj, i)));
            }
            return node;
        }
        return JsonNode.string(String.valueOf(obj));
    }

    public static Collector<JsonNode, ?, JsonNode> arrayCollector() {
        return JsonArrayCollector.INSTANCE;
    }

    public JsonType type();

    public boolean isNull();

    public boolean isString();

    public boolean isNumber();

    public boolean isBoolean();

    public boolean isObject();

    public boolean isArray();

    public boolean isPrimitive();

    public boolean isConstruct();

    public boolean is(JsonType var1);

    public boolean is(JsonType ... var1);

    public JsonNode requireNull();

    public JsonNode requireNotNull();

    public JsonNode requireString();

    public JsonNode requireNotString();

    public JsonNode requireNumber();

    public JsonNode requireNotNumber();

    public JsonNode requireBoolean();

    public JsonNode requireNotBoolean();

    public JsonNode requireObject();

    public JsonNode requireNotObject();

    public JsonNode requireArray();

    public JsonNode requireNotArray();

    public JsonNode requirePrimitive();

    public JsonNode requireNotPrimitive();

    public JsonNode requireConstruct();

    public JsonNode requireNotConstruct();

    public JsonNode require(JsonType var1);

    public JsonNode requireNot(JsonType var1);

    public JsonNode require(JsonType ... var1);

    public JsonNode requireNot(JsonType ... var1);

    public JsonNode ifString(BiConsumer<JsonNode, String> var1);

    public JsonNode ifNumber(BiConsumer<JsonNode, Number> var1);

    public JsonNode ifByte(BiConsumer<JsonNode, Byte> var1);

    public JsonNode ifShort(BiConsumer<JsonNode, Short> var1);

    public JsonNode ifInt(BiConsumer<JsonNode, Integer> var1);

    public JsonNode ifLong(BiConsumer<JsonNode, Long> var1);

    public JsonNode ifFloat(BiConsumer<JsonNode, Float> var1);

    public JsonNode ifDouble(BiConsumer<JsonNode, Double> var1);

    public JsonNode ifBigInteger(BiConsumer<JsonNode, BigInteger> var1);

    public JsonNode ifBigDecimal(BiConsumer<JsonNode, BigDecimal> var1);

    public JsonNode ifBoolean(BiConsumer<JsonNode, Boolean> var1);

    public JsonNode ifNull(Consumer<JsonNode> var1);

    public JsonNode ifArray(Consumer<JsonNode> var1);

    public JsonNode ifObject(Consumer<JsonNode> var1);

    public JsonNode ifPrimitive(Consumer<JsonNode> var1);

    public JsonNode ifConstruct(Consumer<JsonNode> var1);

    public String asExactString();

    public String asString();

    public byte asByte();

    public short asShort();

    public int asInt();

    public long asLong();

    public float asFloat();

    public double asDouble();

    public BigInteger asBigInteger();

    public BigDecimal asBigDecimal();

    public Number asNumber();

    public boolean asBoolean();

    public String[] asStringArray();

    public byte[] asByteArray();

    public short[] asShortArray();

    public int[] asIntArray();

    public long[] asLongArray();

    public float[] asFloatArray();

    public double[] asDoubleArray();

    public BigInteger[] asBigIntegerArray();

    public BigDecimal[] asBigDecimalArray();

    public Number[] asNumberArray();

    public boolean[] asBooleanArray();

    public String[] asStringArray(int var1);

    public byte[] asByteArray(int var1);

    public short[] asShortArray(int var1);

    public int[] asIntArray(int var1);

    public long[] asLongArray(int var1);

    public float[] asFloatArray(int var1);

    public double[] asDoubleArray(int var1);

    public BigInteger[] asBigIntegerArray(int var1);

    public BigDecimal[] asBigDecimalArray(int var1);

    public Number[] asNumberArray(int var1);

    public boolean[] asBooleanArray(int var1);

    public List<JsonNode> asList();

    public Map<String, JsonNode> asMap();

    public JsonNode get(int var1);

    public JsonNode set(int var1, JsonNode var2);

    public JsonNode set(int var1, String var2);

    public JsonNode set(int var1, Number var2);

    public JsonNode set(int var1, Boolean var2);

    public JsonNode add(JsonNode var1);

    public JsonNode add(String var1);

    public JsonNode add(Number var1);

    public JsonNode add(Boolean var1);

    public JsonNode insert(int var1, JsonNode var2);

    public JsonNode insert(int var1, String var2);

    public JsonNode insert(int var1, Number var2);

    public JsonNode insert(int var1, Boolean var2);

    public JsonNode remove(int var1);

    public int size();

    public int length();

    public JsonNode requireSize(int var1);

    public JsonNode clear();

    public JsonNode append(JsonNode var1);

    public JsonNode prepend(JsonNode var1);

    public JsonNode slice(int var1, int var2);

    public JsonNode get(String var1);

    public JsonNode set(String var1, JsonNode var2);

    public JsonNode set(String var1, String var2);

    public JsonNode set(String var1, Number var2);

    public JsonNode set(String var1, Boolean var2);

    public JsonNode remove(String var1);

    public boolean has(String var1);

    public boolean contains(JsonNode var1);

    public Set<String> keySet();

    @Deprecated
    default public Set<String> keys() {
        return this.keySet();
    }

    public Collection<JsonNode> values();

    public Set<Map.Entry<String, JsonNode>> entrySet();

    public Stream<JsonNode> stream();

    public void forEachEntry(BiConsumer<? super String, ? super JsonNode> var1);

    public JsonNode query(String var1);

    public JsonNode query(JsonPath var1);

    public JsonNode deepCopy();

    public JsonNode copy();

    @Override
    default public JsonNode toJson() {
        return this;
    }
}

