/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.shadew.json.AbstractPrimitiveNode;
import net.shadew.json.IncorrectTypeException;
import net.shadew.json.JsonNode;
import net.shadew.json.JsonType;

final class StringNode
extends AbstractPrimitiveNode {
    private final String string;

    StringNode(String string) {
        super(JsonType.STRING);
        this.string = string;
    }

    static void quote(String string, StringBuilder builder, char quote) {
        builder.append(quote);
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            char c = string.charAt(i);
            if (c == quote || c == '\\') {
                builder.append("\\");
            }
            if (c < ' ' || c > '\u007f') {
                if (c == '\n') {
                    builder.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    builder.append("\\r");
                    continue;
                }
                if (c == '\t') {
                    builder.append("\\t");
                    continue;
                }
                builder.append(String.format("\\u%04X", c));
                continue;
            }
            builder.append(c);
        }
        builder.append(quote);
    }

    static String quote(String string) {
        StringBuilder builder = new StringBuilder();
        StringNode.quote(string, builder, '\"');
        return builder.toString();
    }

    @Override
    public JsonNode ifString(BiConsumer<JsonNode, String> action) {
        action.accept(this, this.string);
        return this;
    }

    @Override
    public String asExactString() {
        return this.string;
    }

    @Override
    public String asString() {
        return this.string;
    }

    @Override
    public byte asByte() {
        throw new IncorrectTypeException(JsonType.STRING, JsonType.NUMBER);
    }

    @Override
    public short asShort() {
        throw new IncorrectTypeException(JsonType.STRING, JsonType.NUMBER);
    }

    @Override
    public int asInt() {
        throw new IncorrectTypeException(JsonType.STRING, JsonType.NUMBER);
    }

    @Override
    public long asLong() {
        throw new IncorrectTypeException(JsonType.STRING, JsonType.NUMBER);
    }

    @Override
    public float asFloat() {
        throw new IncorrectTypeException(JsonType.STRING, JsonType.NUMBER);
    }

    @Override
    public double asDouble() {
        throw new IncorrectTypeException(JsonType.STRING, JsonType.NUMBER);
    }

    @Override
    public BigInteger asBigInteger() {
        throw new IncorrectTypeException(JsonType.STRING, JsonType.NUMBER);
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new IncorrectTypeException(JsonType.STRING, JsonType.NUMBER);
    }

    @Override
    public Number asNumber() {
        throw new IncorrectTypeException(JsonType.STRING, JsonType.NUMBER);
    }

    @Override
    public boolean asBoolean() {
        throw new IncorrectTypeException(JsonType.STRING, JsonType.BOOLEAN);
    }

    @Override
    public int length() {
        return this.string.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringNode other = (StringNode)o;
        return this.string.equals(other.string);
    }

    public int hashCode() {
        return Objects.hash(this.string);
    }

    public String toString() {
        return StringNode.quote(this.string);
    }
}

