/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.config.auto;

import de.toxicfox.config.Savable;
import de.toxicfox.config.auto.JsonProcessor;
import de.toxicfox.config.auto.Processor;
import de.toxicfox.config.auto.Saved;
import de.toxicfox.config.auto.processors.BooleanArrayProcessor;
import de.toxicfox.config.auto.processors.BooleanProcessor;
import de.toxicfox.config.auto.processors.DoubleArrayProcessor;
import de.toxicfox.config.auto.processors.DoubleProcessor;
import de.toxicfox.config.auto.processors.IntegerArrayProcessor;
import de.toxicfox.config.auto.processors.IntegerProcessor;
import de.toxicfox.config.auto.processors.LongArrayProcessor;
import de.toxicfox.config.auto.processors.LongProcessor;
import de.toxicfox.config.auto.processors.SavableProcessor;
import de.toxicfox.config.auto.processors.StringArrayProcessor;
import de.toxicfox.config.auto.processors.StringProcessor;
import de.toxicfox.config.premade.ArrayListSavable;
import de.toxicfox.config.premade.ArrayListSavableOOP;
import de.toxicfox.config.premade.HashMapSavable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.shadew.json.JsonNode;

public class AutoSavable
implements Savable {
    private static final HashMap<Class<?>, JsonProcessor> processors = new HashMap();
    public static Logger debug = msg -> {};

    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            Collections.addAll(allFields, fields);
            clazz = clazz.getSuperclass();
        }
        return allFields;
    }

    public static void register(Class<?> target, JsonProcessor processor) {
        debug.debug("Registering new processor for " + target.getName());
        processors.put(target, processor);
    }

    @Override
    public void fromJSON(JsonNode node) {
        HashMap<Class<?>, JsonProcessor> localProcessors = this.loadLocalProcessors();
        for (Field field : AutoSavable.getAllFields(this.getClass())) {
            if (!field.isAnnotationPresent(Saved.class)) continue;
            Saved anno = field.getAnnotation(Saved.class);
            JsonProcessor processor = this.getProcessor(localProcessors, field, anno);
            try {
                field.setAccessible(true);
                field.set(this, processor.fromJson(node.get(field.getName()), field.get(this), anno.optional()));
                debug.debug("Loaded " + field.getName() + " using processor " + processor.getClass().getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public JsonNode toJSON() {
        JsonNode root = JsonNode.object();
        HashMap<Class<?>, JsonProcessor> localProcessors = this.loadLocalProcessors();
        for (Field field : AutoSavable.getAllFields(this.getClass())) {
            if (!field.isAnnotationPresent(Saved.class)) continue;
            JsonProcessor processor = this.getProcessor(localProcessors, field, field.getAnnotation(Saved.class));
            try {
                field.setAccessible(true);
                root.set(field.getName(), processor.toJson(field.get(this)));
                debug.debug("Saved " + field.getName() + " using processor " + processor.getClass().getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return root;
    }

    private HashMap<Class<?>, JsonProcessor> loadLocalProcessors() {
        HashMap localProcessors = new HashMap();
        for (Class<?> clazz : processors.keySet()) {
            localProcessors.put(clazz, processors.get(clazz));
        }
        for (Field field : AutoSavable.getAllFields(this.getClass())) {
            if (!field.isAnnotationPresent(Processor.class)) continue;
            Processor custom = field.getAnnotation(Processor.class);
            try {
                field.setAccessible(true);
                JsonProcessor processor = (JsonProcessor)field.get(this);
                localProcessors.put(custom.target(), processor);
                debug.debug("Found processor " + processor.getClass().getName() + " for " + custom.target().getName() + " in " + field.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return localProcessors;
    }

    private JsonProcessor getProcessor(HashMap<Class<?>, JsonProcessor> localProcessors, Field field, Saved annotation) {
        JsonProcessor processor;
        Class<?> clazz = field.getType();
        if (annotation.remap() != Object.class) {
            debug.debug("Remapping " + clazz.getName() + " to " + annotation.remap().getName() + " for field " + field.getName());
            clazz = annotation.remap();
        }
        if ((processor = localProcessors.get(clazz)) == null) {
            throw new RuntimeException("Could not find JsonProcessor for field " + field.getName() + " with type " + clazz.getName());
        }
        return processor;
    }

    public static HashMap<Class<?>, JsonProcessor> getProcessors() {
        return processors;
    }

    static {
        processors.put(Integer.TYPE, new IntegerProcessor());
        processors.put(int[].class, new IntegerArrayProcessor());
        processors.put(Long.TYPE, new LongProcessor());
        processors.put(long[].class, new LongArrayProcessor());
        processors.put(Double.TYPE, new DoubleProcessor());
        processors.put(double[].class, new DoubleArrayProcessor());
        processors.put(Boolean.TYPE, new BooleanProcessor());
        processors.put(boolean[].class, new BooleanArrayProcessor());
        processors.put(String.class, new StringProcessor());
        processors.put(String[].class, new StringArrayProcessor());
        processors.put(Savable.class, new SavableProcessor());
        processors.put(ArrayListSavable.class, new SavableProcessor());
        processors.put(ArrayListSavableOOP.class, new SavableProcessor());
        processors.put(HashMapSavable.class, new SavableProcessor());
    }

    public static interface Logger {
        public void debug(String var1);
    }
}

