/*
 * Decompiled with CFR 0.152.
 */
package net.shadew.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.shadew.json.AbstractPrimitiveNode;
import net.shadew.json.IncorrectTypeException;
import net.shadew.json.JsonNode;
import net.shadew.json.JsonType;
import net.shadew.json.UnparsedHexNumber;
import net.shadew.json.UnparsedNumber;

final class NumberNode
extends AbstractPrimitiveNode {
    private final Number number;
    private BigInteger bigInteger;
    private BigDecimal bigDecimal;
    private String string;

    NumberNode(Number number) {
        super(JsonType.NUMBER);
        this.number = number;
    }

    @Override
    public JsonNode ifNumber(BiConsumer<JsonNode, Number> action) {
        action.accept(this, this.number);
        return this;
    }

    @Override
    public JsonNode ifByte(BiConsumer<JsonNode, Byte> action) {
        action.accept(this, this.asByte());
        return this;
    }

    @Override
    public JsonNode ifShort(BiConsumer<JsonNode, Short> action) {
        action.accept(this, this.asShort());
        return this;
    }

    @Override
    public JsonNode ifInt(BiConsumer<JsonNode, Integer> action) {
        action.accept(this, this.asInt());
        return this;
    }

    @Override
    public JsonNode ifLong(BiConsumer<JsonNode, Long> action) {
        action.accept(this, this.asLong());
        return this;
    }

    @Override
    public JsonNode ifFloat(BiConsumer<JsonNode, Float> action) {
        action.accept(this, Float.valueOf(this.asFloat()));
        return this;
    }

    @Override
    public JsonNode ifDouble(BiConsumer<JsonNode, Double> action) {
        action.accept(this, this.asDouble());
        return this;
    }

    @Override
    public JsonNode ifBigInteger(BiConsumer<JsonNode, BigInteger> action) {
        action.accept(this, this.asBigInteger());
        return this;
    }

    @Override
    public JsonNode ifBigDecimal(BiConsumer<JsonNode, BigDecimal> action) {
        action.accept(this, this.asBigDecimal());
        return this;
    }

    @Override
    public String asExactString() {
        throw new IncorrectTypeException(JsonType.NUMBER, JsonType.STRING);
    }

    @Override
    public String asString() {
        return this.number.toString();
    }

    @Override
    public byte asByte() {
        return this.number.byteValue();
    }

    @Override
    public short asShort() {
        return this.number.shortValue();
    }

    @Override
    public int asInt() {
        return this.number.intValue();
    }

    @Override
    public long asLong() {
        return this.number.longValue();
    }

    @Override
    public float asFloat() {
        return this.number.floatValue();
    }

    @Override
    public double asDouble() {
        return this.number.doubleValue();
    }

    @Override
    public BigInteger asBigInteger() {
        if (this.bigInteger != null) {
            return this.bigInteger;
        }
        if (this.number instanceof BigInteger) {
            this.bigInteger = (BigInteger)this.number;
            return this.bigInteger;
        }
        if (this.number instanceof BigDecimal) {
            this.bigInteger = ((BigDecimal)this.number).toBigInteger();
            return this.bigInteger;
        }
        if (this.number instanceof UnparsedNumber) {
            this.bigInteger = ((UnparsedNumber)this.number).bigIntegerValue();
            return this.bigInteger;
        }
        if (this.number instanceof UnparsedHexNumber) {
            this.bigInteger = ((UnparsedHexNumber)this.number).bigIntegerValue();
            return this.bigInteger;
        }
        this.bigInteger = this.asBigDecimal().toBigInteger();
        return this.bigInteger;
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (this.bigDecimal != null) {
            return this.bigDecimal;
        }
        if (this.number instanceof BigInteger) {
            this.bigDecimal = new BigDecimal((BigInteger)this.number);
            return this.bigDecimal;
        }
        if (this.number instanceof BigDecimal) {
            this.bigDecimal = (BigDecimal)this.number;
            return this.bigDecimal;
        }
        if (this.number instanceof UnparsedNumber) {
            this.bigDecimal = ((UnparsedNumber)this.number).bigDecimalValue();
            return this.bigDecimal;
        }
        if (this.number instanceof UnparsedHexNumber) {
            this.bigDecimal = ((UnparsedHexNumber)this.number).bigDecimalValue();
            return this.bigDecimal;
        }
        this.bigDecimal = BigDecimal.valueOf(this.asDouble());
        return this.bigDecimal;
    }

    @Override
    public Number asNumber() {
        return this.number;
    }

    @Override
    public boolean asBoolean() {
        throw new IncorrectTypeException(JsonType.NUMBER, JsonType.BOOLEAN);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberNode other = (NumberNode)o;
        return this.asBigDecimal().equals(other.asBigDecimal());
    }

    public int hashCode() {
        return Objects.hash(this.asBigDecimal());
    }

    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        BigDecimal decimal = this.asBigDecimal();
        try {
            BigInteger integer = decimal.toBigIntegerExact();
            this.string = integer.toString();
            return this.string;
        }
        catch (ArithmeticException exc) {
            this.string = decimal.toString();
            return this.string;
        }
    }
}

