/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.toxicutils.database.impl;

import de.toxicfox.toxicutils.Logger;
import de.toxicfox.toxicutils.database.IDatabaseInterface;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class DefaultSQLInterface
implements IDatabaseInterface {
    protected Connection connection;

    protected void createMigrationTable() {
        this.update("CREATE TABLE IF NOT EXISTS __migrations (id VARCHAR(255) PRIMARY KEY)");
    }

    private boolean isMigrationApplied(String migrationID) {
        return this.query("SELECT count(*) FROM __migrations WHERE id = ?", rs -> {
            try {
                return rs.getInt(1) > 0;
            }
            catch (SQLException e) {
                return false;
            }
        }, migrationID).get(0);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void update(String query, Object ... args) {
        try (PreparedStatement statement = this.connection.prepareStatement(query);){
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    statement.setObject(i + 1, args[i]);
                }
            }
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> query(String query, IDatabaseInterface.QueryListMapper<T> mapper, Object ... args) {
        ArrayList<T> list = new ArrayList<T>();
        try (PreparedStatement statement = this.connection.prepareStatement(query);){
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    statement.setObject(i + 1, args[i]);
                }
            }
            ResultSet hasResult = statement.executeQuery();
            while (hasResult.next()) {
                list.add(mapper.apply(hasResult));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    @Override
    public void applyMigration(String id, IDatabaseInterface.Migration migration) {
        if (!this.isMigrationApplied(id)) {
            Logger.log("Applying migration %s", id);
            migration.execute(this);
            this.update("INSERT INTO __migrations (id) VALUES (?)", id);
        }
    }
}

