/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.toxicutils.http.impl;

import de.toxicfox.toxicutils.http.IHTTPInterface;
import de.toxicfox.toxicutils.http.RateLimitException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHTTPInterface
implements IHTTPInterface {
    private final String proxyPort = System.getenv("PROXY_PORT");
    private final String proxyHost = System.getenv("PROXY_HOST");
    private String userAgend = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11";

    @Override
    public String get(String url, Map<String, String> headers) throws IOException, RateLimitException {
        OkHttpClient client = this.createClient(url);
        Request.Builder req = new Request.Builder();
        req.url(url);
        req.addHeader("User-Agent", this.userAgend);
        for (String key : headers.keySet()) {
            req.addHeader(key, headers.get(key));
        }
        try (Response res = client.newCall(req.build()).execute();){
            if (!res.isSuccessful()) {
                if (res.code() == 429) {
                    URL parsedUrl = URI.create(url).toURL();
                    throw new RateLimitException(parsedUrl.getProtocol() + "://" + parsedUrl.getHost());
                }
                throw new IOException("HTTP " + res.code() + " (" + url + ")");
            }
            assert (res.body() != null);
            String string = res.body().string();
            return string;
        }
    }

    @Override
    public String post(String url, String body, Map<String, String> headers) throws IOException, RateLimitException {
        OkHttpClient client = this.createClient(url);
        Request.Builder req = new Request.Builder();
        req.url(url);
        req.method("POST", RequestBody.create((String)body, null));
        req.addHeader("User-Agent", this.userAgend);
        for (String key : headers.keySet()) {
            req.addHeader(key, headers.get(key));
        }
        try (Response res = client.newCall(req.build()).execute();){
            if (!res.isSuccessful()) {
                if (res.code() == 429) {
                    URL parsedUrl = URI.create(url).toURL();
                    throw new RateLimitException(parsedUrl.getProtocol() + "://" + parsedUrl.getHost());
                }
                throw new IOException("HTTP " + res.code() + " (" + url + ")");
            }
            assert (res.body() != null);
            String string = res.body().string();
            return string;
        }
    }

    private OkHttpClient createClient(String url) {
        boolean proxy;
        boolean bl = proxy = url.contains(".onion") || "true".equals(System.getenv("PROXY_FORCE"));
        if (proxy) {
            InetSocketAddress address = new InetSocketAddress(this.proxyHost, Integer.parseInt(this.proxyPort));
            return new OkHttpClient.Builder().proxy(new Proxy(Proxy.Type.SOCKS, address)).build();
        }
        return new OkHttpClient();
    }
}

