/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.toxicutils.registry;

import java.util.HashMap;

public class Registry<Identifier, Entry> {
    private final HashMap<Identifier, Entry> registry = new HashMap();
    private final RegistryProcessor<Identifier, Entry> registryProcessor;

    public Registry(RegistryProcessor<Identifier, Entry> registryProcessor) {
        this.registryProcessor = registryProcessor;
    }

    public void register(Identifier identifier, Entry entry) {
        this.registryProcessor.register(identifier, entry);
        this.registry.put(identifier, entry);
    }

    public Entry get(Identifier identifier) {
        Entry entry = this.registry.get(identifier);
        if (entry == null) {
            throw new IllegalArgumentException("Registry does not contain entry with id " + String.valueOf(identifier));
        }
        return entry;
    }

    public void iterate(RegistryIterator<Identifier, Entry> iterator) {
        for (Identifier identifier : this.registry.keySet()) {
            iterator.process(identifier, this.registry.get(identifier));
        }
    }

    public boolean has(Identifier identifier) {
        return this.registry.containsKey(identifier);
    }

    public HashMap<Identifier, Entry> getRegistry() {
        return this.registry;
    }

    public static interface RegistryProcessor<Identifier, Entry> {
        public void register(Identifier var1, Entry var2);
    }

    public static interface RegistryIterator<Identifier, Entry> {
        public void process(Identifier var1, Entry var2);
    }
}

