/*
 * Decompiled with CFR 0.152.
 */
package de.toxicfox.toxicutils;

import de.toxicfox.toxicutils.Logger;
import java.io.File;

public class TemporaryFile
implements AutoCloseable {
    public static final File BASE = new File("tmp");
    private final File file;

    public TemporaryFile(String fileExtension) {
        if (!BASE.exists()) {
            if (!BASE.mkdir()) {
                throw new RuntimeException("Could not create " + BASE.getPath());
            }
            Logger.log("Created directory %s", BASE.getPath());
        }
        this.file = new File(BASE, TemporaryFile.createTemporaryFileName(fileExtension));
    }

    public static String createTemporaryFileName(String fileExtension) {
        return System.currentTimeMillis() + "_" + Math.random() + "." + fileExtension;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void close() throws Exception {
        if (!this.file.delete()) {
            this.file.deleteOnExit();
        }
    }
}

